/*
 * Decompiled with CFR 0.152.
 */
package com.metropolize.mtz_companions.entity.behaviors;

import com.metropolize.mtz_companions.entity.ServerCompanionEntity;
import com.metropolize.mtzcharacterengine.api.core.behaviour.DelayedBehaviour;
import com.metropolize.mtzcharacterengine.util.BrainUtils;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import org.jetbrains.annotations.Nullable;

public class AnimatableMeleeAttack<E extends ServerCompanionEntity>
extends DelayedBehaviour<E> {
    private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.of((Object[])new Pair[]{Pair.of((Object)MemoryModuleType.f_26372_, (Object)MemoryStatus.VALUE_PRESENT), Pair.of((Object)MemoryModuleType.f_26373_, (Object)MemoryStatus.VALUE_ABSENT)});
    protected Function<E, Integer> attackIntervalSupplier = entity -> 20;
    @Nullable
    protected LivingEntity target = null;

    public AnimatableMeleeAttack(int delayTicks) {
        super(delayTicks);
    }

    public AnimatableMeleeAttack<E> attackInterval(Function<E, Integer> supplier) {
        this.attackIntervalSupplier = supplier;
        return this;
    }

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, E entity) {
        this.target = (LivingEntity)BrainUtils.getMemory(entity, (MemoryModuleType)MemoryModuleType.f_26372_);
        return ((ServerCompanionEntity)entity).m_142582_((Entity)this.target) && ((ServerCompanionEntity)entity).isWithinMeleeAttackRange((Entity)this.target);
    }

    protected void start(E entity) {
        BehaviorUtils.m_22595_(entity, (LivingEntity)this.target);
    }

    protected void stop(E entity) {
        this.target = null;
    }

    protected void doDelayedAction(E entity) {
        if (this.target == null) {
            return;
        }
        if (!((ServerCompanionEntity)entity).m_142582_((Entity)this.target) || !((ServerCompanionEntity)entity).isWithinMeleeAttackRange((Entity)this.target)) {
            return;
        }
        float prevHealth = this.target.m_21223_();
        entity.m_5706_((Entity)this.target);
        entity.m_6674_(InteractionHand.MAIN_HAND);
        if (this.target.m_21223_() != prevHealth) {
            BrainUtils.setForgettableMemory(entity, (MemoryModuleType)MemoryModuleType.f_26373_, (Object)true, (int)this.attackIntervalSupplier.apply(entity));
        }
    }
}

