/*
 * Decompiled with CFR 0.152.
 */
package com.metropolize.mtz_companions.entity.behaviors;

import com.google.common.base.Predicates;
import com.metropolize.mtz_companions.entity.ServerCompanionEntity;
import com.metropolize.mtzcharacterengine.api.core.behaviour.ExtendedBehaviour;
import com.metropolize.mtzcharacterengine.util.BrainUtils;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.Tags;

@ParametersAreNonnullByDefault
public class BlockProjectile<E extends ServerCompanionEntity>
extends ExtendedBehaviour<E> {
    private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.of((Object[])new Pair[]{new Pair((Object)MemoryModuleType.f_26371_, (Object)MemoryStatus.REGISTERED), new Pair((Object)MemoryModuleType.f_148205_, (Object)MemoryStatus.REGISTERED)});
    private static final int BLOCK_DISTANCE = 32;
    private static final int STOP_DELAY = 8;
    private static final int MAX_ROT_PER_TICK_DEGREES = 18;
    private Entity blockTarget = null;
    private int stopDelay = 8;

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    public BlockProjectile() {
        this.cooldownFor(e -> 20);
    }

    protected boolean checkExtraStartConditions(ServerLevel level, E entity) {
        NearestVisibleLivingEntities nearestEntities;
        ItemStack offhand = ((ServerCompanionEntity)entity).m_6844_(EquipmentSlot.OFFHAND);
        if (!offhand.m_204117_(Tags.Items.TOOLS_SHIELDS)) {
            return false;
        }
        this.blockTarget = null;
        List projectiles = level.m_6443_(Projectile.class, new AABB(entity.m_20183_()).m_82400_(32.0), e -> !this.projectileIsStopped((Projectile)e));
        if (!projectiles.isEmpty()) {
            this.blockTarget = projectiles.stream().filter(p -> {
                Vec3 direction;
                Vec3 displacement = p.m_20182_().m_82546_(entity.mtzPosition());
                double angle = Math.acos(displacement.m_82526_(direction = p.m_20184_()) / (displacement.m_165924_() * direction.m_165924_()));
                return Math.abs(angle) < 1.5707963267948966 || Math.abs(angle - Math.PI * 2) < 1.5707963267948966;
            }).findFirst().orElse(null);
        }
        if ((nearestEntities = (NearestVisibleLivingEntities)BrainUtils.getMemory(entity, (MemoryModuleType)MemoryModuleType.f_148205_)) != null && this.blockTarget == null) {
            this.blockTarget = nearestEntities.m_186116_((Predicate)Predicates.and((com.google.common.base.Predicate)Predicates.not(arg_0 -> entity.isAlly(arg_0)), this::isChargingProjectile)).orElse(null);
        }
        return this.blockTarget != null;
    }

    protected void start(E entity) {
        this.stopDelay = 8;
        BrainUtils.setMemory(entity, (MemoryModuleType)MemoryModuleType.f_26371_, (Object)new EntityTracker(this.blockTarget, false));
        ((ServerCompanionEntity)entity).m_6672_(InteractionHand.OFF_HAND);
        this.faceTarget(entity);
    }

    protected void stop(E entity) {
        ((ServerCompanionEntity)entity).m_5810_();
        this.blockTarget = null;
        this.stopDelay = 8;
    }

    protected boolean m_7773_(long gameTime) {
        return false;
    }

    protected boolean shouldKeepRunning(E entity) {
        ServerLevel level = entity.m_284548_();
        if (!((ServerCompanionEntity)entity).m_6844_(EquipmentSlot.OFFHAND).m_204117_(Tags.Items.TOOLS_SHIELDS) || !entity.m_21211_().m_204117_(Tags.Items.TOOLS_SHIELDS)) {
            return false;
        }
        boolean hasValidTarget = this.checkExtraStartConditions(level, entity);
        if (hasValidTarget) {
            this.stopDelay = 8;
            return true;
        }
        --this.stopDelay;
        return this.stopDelay > 0;
    }

    protected void tick(E entity) {
        if (this.blockTarget != null) {
            BrainUtils.setMemory(entity, (MemoryModuleType)MemoryModuleType.f_26371_, (Object)new EntityTracker(this.blockTarget, false));
            this.faceTarget(entity);
        }
    }

    private void faceTarget(E entity) {
        Vec3 displacement = this.blockTarget.m_20182_().m_82546_(((ServerCompanionEntity)entity).mtzPosition());
        double theta_x = Math.toDegrees(Math.atan2(displacement.f_82481_, displacement.f_82479_));
        double theta_z = theta_x - 90.0;
        float diff = (float)Mth.m_14008_((double)-18.0, (double)(theta_z - (double)entity.m_146908_()), (double)18.0);
        entity.m_146922_(entity.m_146908_() + diff);
    }

    private boolean projectileIsStopped(Projectile projectile) {
        if (!projectile.m_6084_() || projectile.f_19794_) {
            return true;
        }
        if (projectile instanceof AbstractArrow) {
            AbstractArrow arrow = (AbstractArrow)projectile;
            return arrow.f_36703_;
        }
        return false;
    }

    private boolean isChargingProjectile(LivingEntity entity) {
        if (entity.m_21093_(CrossbowItem::m_40932_)) {
            return true;
        }
        if (!entity.m_6117_()) {
            return false;
        }
        ItemStack usedItem = entity.m_21211_();
        if (usedItem.m_41720_() instanceof BowItem) {
            return 20 - entity.m_21252_() < 10;
        }
        return usedItem.m_41720_() instanceof TridentItem;
    }
}

