/*
 * Decompiled with CFR 0.152.
 */
package com.metropolize.mtz_companions.entity.behaviors;

import com.metropolize.mtz_companions.entity.CompanionContainer;
import com.metropolize.mtz_companions.entity.ServerCompanionEntity;
import com.metropolize.mtz_companions.entity.data.memories.MemoryModuleTypes;
import com.metropolize.mtzcharacterengine.api.core.behaviour.ExtendedBehaviour;
import com.metropolize.mtzcharacterengine.util.BrainUtils;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.registries.RegistryObject;
import org.slf4j.Logger;

@ParametersAreNonnullByDefault
public class CraftItem<E extends ServerCompanionEntity>
extends ExtendedBehaviour<E> {
    private static final Logger log = LogUtils.getLogger();
    private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.of((Object[])new Pair[]{Pair.of((Object)((MemoryModuleType)MemoryModuleTypes.ASYNC_KNOWN_CRAFTING_TABLES.get()), (Object)MemoryStatus.REGISTERED), Pair.of((Object)((MemoryModuleType)MemoryModuleTypes.CRAFTING_TARGET.get()), (Object)MemoryStatus.VALUE_PRESENT)});
    protected Recipe<?> recipeToCraft = null;
    protected List<Item> ingredientsNeeded = null;
    protected boolean usesCraftingTable = true;
    protected int startDelay = 20;

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkExtraStartConditions(ServerLevel level, E entity) {
        List craftingTables;
        RegistryObject<MemoryModuleType<List<BlockPos>>> stack;
        Pair craftingTarget = (Pair)BrainUtils.getMemory(entity, (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.CRAFTING_TARGET.get()));
        this.recipeToCraft = (Recipe)craftingTarget.getFirst();
        this.ingredientsNeeded = (List)craftingTarget.getSecond();
        for (Item item : this.ingredientsNeeded) {
            stack = ((ServerCompanionEntity)entity).getInventory().findFirstItemSlot(item);
            if (stack != null) continue;
            return false;
        }
        Item lastCrafted = (Item)BrainUtils.getMemory(entity, (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.PREVIOUS_CRAFTING_TARGET.get()));
        if (this.recipeToCraft.m_8004_(2, 2)) {
            this.usesCraftingTable = false;
            return this.checkStartDelay(level, lastCrafted);
        }
        stack = MemoryModuleTypes.ASYNC_KNOWN_CRAFTING_TABLES;
        synchronized (stack) {
            craftingTables = (List)BrainUtils.getMemory(entity, (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.ASYNC_KNOWN_CRAFTING_TABLES.get()));
        }
        if (craftingTables == null || craftingTables.isEmpty()) {
            return false;
        }
        BlockPos closestTable = (BlockPos)craftingTables.get(0);
        if (!entity.m_9236_().m_8055_(closestTable).m_60713_(Blocks.f_50091_)) {
            return false;
        }
        return this.checkStartDelay(level, lastCrafted) && ((ServerCompanionEntity)entity).isBlockInRange(closestTable);
    }

    protected void start(E entity) {
        ItemStack unableToAdd;
        CompanionContainer inventory = ((ServerCompanionEntity)entity).getInventory();
        for (Item item : this.ingredientsNeeded) {
            ItemStack stack = inventory.findFirstItemSlot(item);
            if (stack == null) {
                log.error("SetCraftingTarget: could not find {} in inventory", (Object)item);
                return;
            }
            stack.m_41774_(1);
        }
        if (this.usesCraftingTable) {
            entity.m_6674_(InteractionHand.MAIN_HAND);
        }
        if (!(unableToAdd = inventory.addItem(this.recipeToCraft.m_8043_(entity.m_9236_().m_9598_()).m_41777_())).m_41619_()) {
            entity.m_19983_(unableToAdd);
        }
    }

    protected void stop(E entity) {
        this.usesCraftingTable = true;
        this.recipeToCraft = null;
        this.ingredientsNeeded = null;
        this.startDelay = 20;
        BrainUtils.clearMemory(entity, (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.CRAFTING_TARGET.get()));
    }

    private boolean checkStartDelay(ServerLevel level, Item lastCrafted) {
        Item toCraft = this.recipeToCraft.m_8043_(level.m_9598_()).m_41720_();
        if (this.startDelay != 0 && toCraft != lastCrafted) {
            --this.startDelay;
            return false;
        }
        return true;
    }
}

