/*
 * Decompiled with CFR 0.152.
 */
package com.metropolize.mtz_companions.entity.behaviors;

import com.metropolize.mtz_companions.entity.ServerCompanionEntity;
import com.metropolize.mtzcharacterengine.api.core.behaviour.ExtendedBehaviour;
import com.metropolize.mtzcharacterengine.util.BrainUtils;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiPredicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraftforge.common.ForgeMod;

public class EnterNearbyBoat<E extends ServerCompanionEntity>
extends ExtendedBehaviour<E> {
    private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.of();
    private BiPredicate<E, Boat> boatPredicate = (entity, boat) -> true;
    private Boat target = null;

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    public EnterNearbyBoat<E> setPredicate(BiPredicate<E, Boat> predicate) {
        this.boatPredicate = predicate;
        return this;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, E entity) {
        double reach = entity.m_21133_((Attribute)ForgeMod.BLOCK_REACH.get());
        List nearbyBoats = level.m_45976_(Boat.class, entity.m_20191_().m_82400_(reach));
        if (entity.m_20159_() && nearbyBoats.stream().anyMatch(boat -> boat.equals((Object)entity.m_20202_()))) {
            return false;
        }
        Optional<Boat> optionalBoat = nearbyBoats.stream().filter(arg_0 -> entity.m_142582_(arg_0)).filter(boat -> this.boatPredicate.test(entity, (Boat)boat)).findFirst();
        if (optionalBoat.isPresent()) {
            this.target = optionalBoat.get();
            return true;
        }
        return false;
    }

    protected void start(E entity) {
        entity.m_20260_(false);
        ((ServerCompanionEntity)entity).f_20901_ = 0.0f;
        boolean success = entity.m_20329_((Entity)this.target);
        if (success) {
            entity.m_20329_((Entity)this.target);
        }
        if (this.target.m_146898_()) {
            BrainUtils.clearMemory(entity, (MemoryModuleType)MemoryModuleType.f_26370_);
        }
    }

    protected void stop(E entity) {
        this.target = null;
    }
}

