/*
 * Decompiled with CFR 0.152.
 */
package com.metropolize.mtz_companions.entity.behaviors;

import com.metropolize.mtz_companions.entity.ServerCompanionEntity;
import com.metropolize.mtz_companions.entity.data.memories.MemoryModuleTypes;
import com.metropolize.mtz_companions.navigation.path.Path;
import com.metropolize.mtzcharacterengine.api.core.behaviour.ExtendedBehaviour;
import com.metropolize.mtzcharacterengine.util.BrainUtils;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

@ParametersAreNonnullByDefault
public class HarvestBlockTarget<E extends ServerCompanionEntity>
extends ExtendedBehaviour<E> {
    private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.of((Object[])new Pair[]{Pair.of((Object)MemoryModuleType.f_26371_, (Object)MemoryStatus.REGISTERED), Pair.of((Object)((MemoryModuleType)MemoryModuleTypes.BLOCK_TARGET.get()), (Object)MemoryStatus.VALUE_PRESENT), Pair.of(MemoryModuleTypes.PATH.get(), (Object)MemoryStatus.REGISTERED)});
    private static final int DIAMONDS_MESSAGE_COOLDOWN = 1200;
    protected BlockPos target = null;
    protected BlockState blockState = null;
    private ItemStack mainHandItem = null;
    private long previousMessageGameTime = 0L;

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, E entity) {
        BlockPos block = (BlockPos)BrainUtils.getMemory(entity, (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.BLOCK_TARGET.get()));
        this.blockState = level.m_8055_(block);
        if (this.blockState.m_60795_()) {
            return false;
        }
        Path path = (Path)BrainUtils.getMemory(entity, MemoryModuleTypes.PATH.get());
        if (path != null && !path.isAtEnd((ServerCompanionEntity)entity)) {
            return false;
        }
        ItemStack mainHandTarget = (ItemStack)BrainUtils.getMemory(entity, (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.MAINHAND_TARGET.get()));
        if (mainHandTarget != null && ItemStack.m_150942_((ItemStack)mainHandTarget, (ItemStack)entity.m_21205_()) && ((ServerCompanionEntity)entity).isBlockInRange(block) && !entity.m_20069_() && ((ServerCompanionEntity)entity).hasLineOfSight(block, false)) {
            this.target = block;
        }
        return !((ServerCompanionEntity)entity).getBlockBreakControl().wasBreaking() && this.target != null;
    }

    protected boolean m_7773_(long gameTime) {
        return false;
    }

    protected void start(E entity) {
        this.mainHandItem = entity.m_21205_().m_41777_();
        ((ServerCompanionEntity)entity).getBlockBreakControl().breakBlock((ServerLevel)entity.m_9236_(), this.target, false);
        if (this.blockState.m_60713_(Blocks.f_50089_) && !((ServerCompanionEntity)entity).getInventory().getItemCounts().containsKey(Items.f_42415_) && entity.m_9236_().m_46467_() - this.previousMessageGameTime > 1200L) {
            this.previousMessageGameTime = entity.m_9236_().m_46467_();
            ((ServerCompanionEntity)entity).sendChatMessage((Component)Component.m_237115_((String)"companion.chat.exploration.diamonds"));
        }
    }

    protected void tick(E entity) {
        ((ServerCompanionEntity)entity).getBlockBreakControl().breakBlock((ServerLevel)entity.m_9236_(), this.target, false);
    }

    protected boolean shouldKeepRunning(E entity) {
        return this.target != null && !entity.m_9236_().m_46859_(this.target) && ((ServerCompanionEntity)entity).isBlockInRange(this.target) && ((ServerCompanionEntity)entity).getBlockBreakControl().getTarget().equals(this.target) && ItemStack.m_150942_((ItemStack)this.mainHandItem, (ItemStack)entity.m_21205_());
    }

    protected void stop(E entity) {
        BrainUtils.clearMemory(entity, (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.BLOCK_TARGET.get()));
        this.target = null;
        this.blockState = null;
        this.mainHandItem = null;
    }
}

