/*
 * Decompiled with CFR 0.152.
 */
package com.metropolize.mtz_companions.entity.behaviors;

import com.metropolize.mtz_companions.core.MetropolizeBlockPos;
import com.metropolize.mtz_companions.entity.ServerCompanionEntity;
import com.metropolize.mtz_companions.entity.data.memories.MemoryModuleTypes;
import com.metropolize.mtz_companions.utils.BlockPlacementUtils;
import com.metropolize.mtzcharacterengine.api.core.behaviour.ExtendedBehaviour;
import com.metropolize.mtzcharacterengine.util.BrainUtils;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

@ParametersAreNonnullByDefault
public class PlaceTemporaryBlock<E extends ServerCompanionEntity>
extends ExtendedBehaviour<E> {
    private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.of((Object[])new Pair[]{Pair.of((Object)MemoryModuleType.f_26371_, (Object)MemoryStatus.REGISTERED), Pair.of((Object)((MemoryModuleType)MemoryModuleTypes.BLOCK_PLACE_POS.get()), (Object)MemoryStatus.VALUE_PRESENT), Pair.of((Object)((MemoryModuleType)MemoryModuleTypes.BLOCK_PLACE_ITEM.get()), (Object)MemoryStatus.VALUE_PRESENT)});
    private static final int FORGET_CLEANUP_TIME = 6000;
    protected BlockPos targetPos = null;
    protected Pair<BlockPos, Direction> adjacentBlock = null;
    private ItemStack mainHandBlock = null;

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, E entity) {
        Item item;
        BlockPos block = (BlockPos)BrainUtils.getMemory(entity, (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.BLOCK_PLACE_POS.get()));
        if (block == null || !((ServerCompanionEntity)entity).isBlockInRange(block) || !((ServerCompanionEntity)entity).hasLineOfSight(block, false)) {
            return false;
        }
        ItemStack mainHandTarget = (ItemStack)BrainUtils.getMemory(entity, (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.MAINHAND_TARGET.get()));
        if (mainHandTarget != null && ItemStack.m_150942_((ItemStack)mainHandTarget, (ItemStack)entity.m_21205_()) && (item = mainHandTarget.m_41720_()) instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            if (!BlockPlacementUtils.canPlace(entity, blockItem, block)) {
                return false;
            }
            Direction d = BlockPlacementUtils.getSupportingDirection(entity, (Level)level, new MetropolizeBlockPos(block));
            if (d != null) {
                this.adjacentBlock = Pair.of((Object)block.m_121945_(d), (Object)d.m_122424_());
            }
        }
        if (this.adjacentBlock != null) {
            this.targetPos = block;
            this.mainHandBlock = entity.m_21205_();
            return true;
        }
        return false;
    }

    protected void start(E entity) {
        ServerLevel level = (ServerLevel)entity.m_9236_();
        BlockPlaceContext context = new BlockPlaceContext(entity, InteractionHand.MAIN_HAND, this.mainHandBlock, new BlockHitResult(((BlockPos)this.adjacentBlock.getFirst()).m_252807_(), (Direction)this.adjacentBlock.getSecond(), (BlockPos)this.adjacentBlock.getFirst(), false));
        BlockState placementBlockState = ((BlockItem)this.mainHandBlock.m_41720_()).m_40614_().m_5573_(context);
        BlockPlacementUtils.placeBlock(entity, level, this.mainHandBlock, placementBlockState, this.targetPos, (Direction)this.adjacentBlock.getSecond(), false);
        BrainUtils.setForgettableMemory(entity, (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.CRAFTING_BLOCK_CLEANUP_TARGET.get()), (Object)Pair.of((Object)this.targetPos, (Object)level.m_8055_(this.targetPos)), (int)6000);
    }

    protected void stop(E entity) {
        this.targetPos = null;
        this.adjacentBlock = null;
        this.mainHandBlock = null;
        BrainUtils.clearMemory(entity, (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.BLOCK_PLACE_ITEM.get()));
        BrainUtils.clearMemory(entity, (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.BLOCK_PLACE_POS.get()));
    }
}

