/*
 * Decompiled with CFR 0.152.
 */
package com.metropolize.mtz_companions.entity.behaviors;

import com.metropolize.mtz_companions.entity.ServerCompanionEntity;
import com.metropolize.mtz_companions.entity.data.memories.MemoryModuleTypes;
import com.metropolize.mtz_companions.entity.metropolize.MtzActivities;
import com.metropolize.mtz_companions.navigation.MtzWalkTarget;
import com.metropolize.mtzcharacterengine.api.core.behaviour.ExtendedBehaviour;
import com.metropolize.mtzcharacterengine.util.BrainUtils;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

@ParametersAreNonnullByDefault
public class ReturnHome<E extends ServerCompanionEntity>
extends ExtendedBehaviour<E> {
    private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.of();
    protected ServerLevel level = null;
    private static final int RETURN_HOME_DISTANCE = 64;
    private BlockPos homePos = null;
    private MtzWalkTarget walkTarget = null;

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, E entity) {
        if (BrainUtils.hasMemory(entity, (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.PATHFINDING_TETHER.get()))) {
            if (((ServerCompanionEntity)entity).getOverrideActivity() == MtzActivities.RETURN_HOME.get()) {
                ((ServerCompanionEntity)entity).setOverrideActivity(null);
            }
            return false;
        }
        boolean isFarFromHome = this.isFarFromHome(level, entity);
        if (!isFarFromHome && ((ServerCompanionEntity)entity).getOverrideActivity() == MtzActivities.RETURN_HOME.get()) {
            ((ServerCompanionEntity)entity).setOverrideActivity(null);
        }
        return isFarFromHome;
    }

    private boolean isFarFromHome(ServerLevel level, E entity) {
        this.level = level;
        if (((ServerCompanionEntity)entity).getHomePosition() != null && ((ServerCompanionEntity)entity).getHomeDimension() == level.m_46472_()) {
            this.homePos = ((ServerCompanionEntity)entity).getHomePosition();
            return entity.m_20238_(this.homePos.m_252807_()) > 4096.0;
        }
        ServerPlayer nearbyPlayer = (ServerPlayer)this.level.m_45930_(entity, 64.0);
        if (nearbyPlayer != null && nearbyPlayer.m_8961_() != null && nearbyPlayer.m_8963_() == level.m_46472_()) {
            this.homePos = nearbyPlayer.m_8961_();
            return entity.m_20238_(this.homePos.m_252807_()) > 4096.0;
        }
        if (entity.m_8961_() != null && entity.m_8963_() == level.m_46472_()) {
            this.homePos = entity.m_8961_();
            return entity.m_20238_(this.homePos.m_252807_()) > 4096.0;
        }
        return false;
    }

    protected void start(E entity) {
        this.walkTarget = new MtzWalkTarget(this.homePos, 1.0f, 64.0);
        BrainUtils.setMemory(entity, (MemoryModuleType)MemoryModuleType.f_26370_, (Object)((Object)this.walkTarget));
    }

    protected boolean shouldKeepRunning(E entity) {
        return !this.walkTarget.isReached((ServerCompanionEntity)entity, ((ServerCompanionEntity)entity).mtzBlockPosition()) && this.walkTarget.equals(BrainUtils.getMemory(entity, (MemoryModuleType)MemoryModuleType.f_26370_));
    }

    protected boolean m_7773_(long gameTime) {
        return false;
    }

    protected void stop(E entity) {
        this.level = null;
        this.homePos = null;
        if (((ServerCompanionEntity)entity).getOverrideActivity() == MtzActivities.RETURN_HOME.get() && this.walkTarget.isReached((ServerCompanionEntity)entity, ((ServerCompanionEntity)entity).mtzBlockPosition())) {
            ((ServerCompanionEntity)entity).setOverrideActivity(null);
        }
        BrainUtils.clearMemory(entity, (MemoryModuleType)MemoryModuleType.f_26370_);
    }
}

