/*
 * Decompiled with CFR 0.152.
 */
package com.metropolize.mtz_companions.entity.behaviors;

import com.metropolize.mtz_companions.entity.ServerCompanionEntity;
import com.metropolize.mtz_companions.entity.data.memories.MemoryModuleTypes;
import com.metropolize.mtzcharacterengine.api.core.behaviour.ExtendedBehaviour;
import com.metropolize.mtzcharacterengine.util.BrainUtils;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Predicate;
import lombok.NonNull;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.player.Player;

public class SetAttackTarget<E extends ServerCompanionEntity>
extends ExtendedBehaviour<E> {
    private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.of((Object[])new Pair[]{Pair.of((Object)MemoryModuleType.f_26372_, (Object)MemoryStatus.REGISTERED), Pair.of((Object)MemoryModuleType.f_148205_, (Object)MemoryStatus.REGISTERED)});
    protected Predicate<LivingEntity> attackablePredicate = LivingEntity::m_6084_;
    protected LivingEntity toTarget = null;

    public SetAttackTarget<E> attackablePredicate(Predicate<LivingEntity> predicate) {
        this.attackablePredicate = predicate;
        return this;
    }

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, E entity) {
        NearestVisibleLivingEntities nearbyEntities;
        List nearestHostile = (List)BrainUtils.getMemory(entity, (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.NEAREST_ENEMIES.get()));
        if (nearestHostile != null && !nearestHostile.isEmpty()) {
            List<LivingEntity> attackable = nearestHostile.stream().filter(this.attackablePredicate).toList();
            this.toTarget = attackable.stream().filter(e -> {
                Mob mob;
                return e instanceof Mob && (mob = (Mob)e).m_5448_() == entity;
            }).findFirst().orElse(null);
            if (this.toTarget == null) {
                this.toTarget = attackable.stream().findFirst().orElse(null);
            }
            if (this.toTarget != null) {
                return true;
            }
        }
        if ((nearbyEntities = (NearestVisibleLivingEntities)BrainUtils.getMemory(entity, (MemoryModuleType)MemoryModuleType.f_148205_)) == null) {
            return false;
        }
        this.toTarget = this.getTargetsFromAllies(nearbyEntities);
        return this.toTarget != null;
    }

    protected LivingEntity getTargetsFromAllies(@NonNull NearestVisibleLivingEntities nearbyEntities) {
        if (nearbyEntities == null) {
            throw new NullPointerException("nearbyEntities is marked non-null but is null");
        }
        return nearbyEntities.m_186116_(e -> this.attackablePredicate.test((LivingEntity)e) && !SetAttackTarget.isOwnedByFriendly(e) && e.f_20888_ != null).orElse(null);
    }

    protected void start(E entity) {
        BrainUtils.setMemory(entity, (MemoryModuleType)MemoryModuleType.f_26372_, (Object)this.toTarget);
        BrainUtils.clearMemory(entity, (MemoryModuleType)MemoryModuleType.f_26326_);
        this.toTarget = null;
    }

    private static boolean isOwnedByFriendly(LivingEntity entity) {
        OwnableEntity ownable;
        if (entity instanceof OwnableEntity && (ownable = (OwnableEntity)entity).m_269323_() instanceof Player) {
            return true;
        }
        return entity.m_8077_();
    }
}

