/*
 * Decompiled with CFR 0.152.
 */
package com.metropolize.mtz_companions.entity.behaviors;

import com.metropolize.mtz_companions.entity.CompanionContainer;
import com.metropolize.mtz_companions.entity.ServerCompanionEntity;
import com.metropolize.mtz_companions.entity.data.memories.MemoryModuleTypes;
import com.metropolize.mtz_companions.entity.metropolize.MtzItemConstants;
import com.metropolize.mtz_companions.navigation.MtzWalkTarget;
import com.metropolize.mtz_companions.utils.RecipeUtils;
import com.metropolize.mtzcharacterengine.api.core.behaviour.ExtendedBehaviour;
import com.metropolize.mtzcharacterengine.util.BrainUtils;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.registries.RegistryObject;
import org.slf4j.Logger;

@ParametersAreNonnullByDefault
public class SetCraftingTarget<E extends ServerCompanionEntity>
extends ExtendedBehaviour<E> {
    private static final Logger log = LogUtils.getLogger();
    private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.of((Object[])new Pair[]{Pair.of((Object)((MemoryModuleType)MemoryModuleTypes.ASYNC_KNOWN_CRAFTING_TABLES.get()), (Object)MemoryStatus.REGISTERED), Pair.of((Object)((MemoryModuleType)MemoryModuleTypes.CRAFTING_TARGET.get()), (Object)MemoryStatus.REGISTERED), Pair.of((Object)((MemoryModuleType)MemoryModuleTypes.PREVIOUS_CRAFTING_TARGET.get()), (Object)MemoryStatus.REGISTERED)});
    protected BlockPos craftingTable = null;
    protected Recipe<?> recipeToCraft = null;
    protected List<Item> ingredientsNeeded = null;

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkExtraStartConditions(ServerLevel level, E entity) {
        Collection<Item> wantedItems = ((ServerCompanionEntity)entity).getWantedItems();
        if (wantedItems == null) {
            return false;
        }
        CompanionContainer inventory = ((ServerCompanionEntity)entity).getInventory();
        wantedItems = wantedItems.stream().filter(item -> !MtzItemConstants.CRAFTING_EXCLUSIONS.contains(item)).filter(item -> inventory.canFitItemStack(item.m_7968_())).toList();
        for (Item item2 : wantedItems) {
            Pair<Recipe<?>, IntList> recipePair;
            if (item2 == Items.f_41960_ && !level.m_6443_(ItemEntity.class, entity.m_20191_().m_82400_(5.0), e -> e.m_32055_().m_150930_(Items.f_41960_)).isEmpty() || (recipePair = RecipeUtils.getUsableRecipe(RecipeType.f_44107_, item2, entity)) == null) continue;
            Recipe recipe = (Recipe)recipePair.getFirst();
            if (!recipe.m_8004_(2, 2)) {
                List nearestCraftingTables;
                RegistryObject<MemoryModuleType<List<BlockPos>>> registryObject = MemoryModuleTypes.ASYNC_KNOWN_CRAFTING_TABLES;
                synchronized (registryObject) {
                    nearestCraftingTables = (List)BrainUtils.getMemory(entity, (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.ASYNC_KNOWN_CRAFTING_TABLES.get()));
                }
                if (nearestCraftingTables == null || nearestCraftingTables.isEmpty() || ((BlockPos)nearestCraftingTables.get(0)).m_123331_((Vec3i)entity.m_20183_()) >= Math.pow(32.0, 2.0)) {
                    if (!((ServerCompanionEntity)entity).getInventory().m_36063_(new ItemStack((ItemLike)Items.f_41960_))) {
                        continue;
                    }
                } else {
                    this.craftingTable = (BlockPos)nearestCraftingTables.get(0);
                }
            }
            this.recipeToCraft = recipe;
            this.ingredientsNeeded = ((IntList)recipePair.getSecond()).intStream().mapToObj(StackedContents::m_36454_).filter(itemStack -> !itemStack.m_41619_()).map(ItemStack::m_41720_).toList();
            return true;
        }
        return false;
    }

    protected void start(E entity) {
        if (this.craftingTable != null) {
            BrainUtils.setMemory(entity, (MemoryModuleType)MemoryModuleType.f_26370_, (Object)((Object)new MtzWalkTarget(this.craftingTable, 1.0f, (double)((int)entity.m_21133_((Attribute)ForgeMod.BLOCK_REACH.get())))));
            BrainUtils.setMemory(entity, (MemoryModuleType)MemoryModuleType.f_26371_, (Object)new BlockPosTracker(this.craftingTable));
        }
        BrainUtils.setMemory(entity, (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.CRAFTING_TARGET.get()), (Object)Pair.of(this.recipeToCraft, this.ingredientsNeeded));
        if (this.craftingTable == null && !this.recipeToCraft.m_8004_(2, 2)) {
            BrainUtils.setMemory(entity, (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.BLOCK_PLACE_ITEM.get()), (Object)((ServerCompanionEntity)entity).getInventory().findFirstItemSlot(Items.f_41960_));
        }
        BrainUtils.setForgettableMemory(entity, (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.CRAFTING_BLOCK_CLEANUP_DELAY.get()), (Object)true, (int)20);
    }

    protected void stop(E entity) {
        BrainUtils.setForgettableMemory(entity, (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.PREVIOUS_CRAFTING_TARGET.get()), (Object)this.recipeToCraft.m_8043_(entity.m_9236_().m_9598_()).m_41720_(), (int)20);
        this.craftingTable = null;
        this.recipeToCraft = null;
        this.ingredientsNeeded = null;
    }
}

