/*
 * Decompiled with CFR 0.152.
 */
package com.metropolize.mtz_companions.entity.behaviors;

import com.metropolize.mtz_companions.entity.CompanionContainer;
import com.metropolize.mtz_companions.entity.ServerCompanionEntity;
import com.metropolize.mtz_companions.entity.data.memories.MemoryModuleTypes;
import com.metropolize.mtzcharacterengine.api.core.behaviour.ExtendedBehaviour;
import com.metropolize.mtzcharacterengine.util.BrainUtils;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;

public class SetEatTarget<E extends ServerCompanionEntity>
extends ExtendedBehaviour<E> {
    private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.of((Object[])new Pair[]{Pair.of((Object)((MemoryModuleType)MemoryModuleTypes.USE_TARGET.get()), (Object)MemoryStatus.REGISTERED)});
    protected Predicate<ItemStack> itemStackPredicate = itemStack -> itemStack.m_41720_().m_41472_() && this.getFoodProperties((ItemStack)itemStack) != null && this.getFoodProperties((ItemStack)itemStack).m_38744_() > 0;
    protected Predicate<E> predicate = entity -> entity.m_36324_().m_38721_() && entity.getInventory().m_216874_(itemStack -> this.itemStackPredicate.test((ItemStack)itemStack));
    protected ItemStack target = null;

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    public SetEatTarget<E> predicate(Predicate<E> predicate, Predicate<ItemStack> itemStackPredicate) {
        this.predicate = predicate;
        this.itemStackPredicate = itemStackPredicate;
        return this;
    }

    public SetEatTarget<E> predicate(Predicate<ItemStack> itemStackPredicate) {
        this.itemStackPredicate = itemStackPredicate;
        return this;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, E entity) {
        ItemStack bestBeneficialItem = null;
        ItemStack bestHarmfulItem = null;
        if (this.predicate.test(entity)) {
            CompanionContainer inventory = ((ServerCompanionEntity)entity).getInventory();
            for (int i = 0; i < inventory.m_6643_(); ++i) {
                ItemStack itemStack = inventory.m_8020_(i);
                FoodProperties itemProps = this.getFoodProperties(itemStack);
                if (!this.itemStackPredicate.test(itemStack)) continue;
                if (this.hasHarmfulEffects(itemStack)) {
                    if (bestHarmfulItem != null && this.getFoodProperties(bestHarmfulItem).m_38744_() >= itemProps.m_38744_()) continue;
                    bestHarmfulItem = itemStack;
                    continue;
                }
                if (bestBeneficialItem != null && this.getFoodProperties(bestBeneficialItem).m_38744_() <= itemProps.m_38744_()) continue;
                bestBeneficialItem = itemStack;
            }
        }
        if (bestBeneficialItem != null) {
            this.target = bestBeneficialItem;
        } else if (bestHarmfulItem != null) {
            this.target = bestHarmfulItem;
        }
        return this.target != null;
    }

    protected void start(E entity) {
        BrainUtils.setMemory(entity, (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.USE_TARGET.get()), (Object)this.target);
        BrainUtils.setMemory(entity, (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.MAINHAND_TARGET.get()), (Object)this.target);
    }

    protected void stop(E entity) {
        this.target = null;
    }

    private FoodProperties getFoodProperties(ItemStack itemStack) {
        return itemStack.m_41720_().getFoodProperties(itemStack, null);
    }

    private boolean hasHarmfulEffects(ItemStack itemStack) {
        return this.getFoodProperties(itemStack).m_38749_().stream().anyMatch(effectInstance -> !((MobEffectInstance)effectInstance.getFirst()).m_19544_().m_19486_());
    }
}

