/*
 * Decompiled with CFR 0.152.
 */
package com.metropolize.mtz_companions.entity.behaviors;

import com.metropolize.mtz_companions.capabilities.IDomesticatedCapability;
import com.metropolize.mtz_companions.capabilities.IProtectedBlocksCapability;
import com.metropolize.mtz_companions.entity.ServerCompanionEntity;
import com.metropolize.mtz_companions.utils.LootTableUtils;
import com.metropolize.mtzcharacterengine.api.core.behaviour.ExtendedBehaviour;
import com.metropolize.mtzcharacterengine.util.BrainUtils;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import lombok.NonNull;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.Tags;

public class SetHuntingTarget<E extends ServerCompanionEntity>
extends ExtendedBehaviour<E> {
    private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.of((Object[])new Pair[]{Pair.of((Object)MemoryModuleType.f_26372_, (Object)MemoryStatus.REGISTERED), Pair.of((Object)MemoryModuleType.f_148205_, (Object)MemoryStatus.REGISTERED)});
    protected Predicate<LivingEntity> attackablePredicate = LivingEntity::m_6084_;
    protected Predicate<LivingEntity> huntablePredicate = e -> !(e instanceof NeutralMob) && !SetHuntingTarget.isOwnedByFriendly(e) && !SetHuntingTarget.checkAndMarkIfDomesticated((ServerLevel)e.m_9236_(), e);
    protected LivingEntity toTarget = null;

    public SetHuntingTarget<E> attackablePredicate(Predicate<LivingEntity> predicate) {
        this.attackablePredicate = predicate;
        return this;
    }

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, E entity) {
        NearestVisibleLivingEntities nearbyEntities = (NearestVisibleLivingEntities)BrainUtils.getMemory(entity, (MemoryModuleType)MemoryModuleType.f_148205_);
        if (nearbyEntities == null) {
            return false;
        }
        this.toTarget = this.getHuntingTargets(nearbyEntities, entity);
        return this.toTarget != null;
    }

    protected LivingEntity getHuntingTargets(@NonNull NearestVisibleLivingEntities nearbyEntities, E entity) {
        if (nearbyEntities == null) {
            throw new NullPointerException("nearbyEntities is marked non-null but is null");
        }
        Set<Item> wantedItems = ((ServerCompanionEntity)entity).getWantedItems();
        return nearbyEntities.m_186116_(e -> {
            if (!this.attackablePredicate.test((LivingEntity)e)) return false;
            if (!this.huntablePredicate.test((LivingEntity)e)) return false;
            if (!LootTableUtils.getAllMobDrops(e, e.m_269291_().m_269075_((Player)entity)).keySet().stream().anyMatch(wantedItems::contains)) return false;
            return true;
        }).orElse(null);
    }

    protected void start(E entity) {
        BrainUtils.setMemory(entity, (MemoryModuleType)MemoryModuleType.f_26372_, (Object)this.toTarget);
        BrainUtils.clearMemory(entity, (MemoryModuleType)MemoryModuleType.f_26326_);
        this.toTarget = null;
    }

    private static boolean isOwnedByFriendly(LivingEntity entity) {
        OwnableEntity ownable;
        if (entity instanceof OwnableEntity && (ownable = (OwnableEntity)entity).m_269323_() instanceof Player) {
            return true;
        }
        return entity.m_8077_();
    }

    private static boolean checkAndMarkIfDomesticated(ServerLevel level, LivingEntity entity) {
        if (entity instanceof Animal) {
            Animal animal = (Animal)entity;
            long gameTime = level.m_46467_();
            IDomesticatedCapability domesticated = (IDomesticatedCapability)animal.getCapability(IDomesticatedCapability.CAPABILITY).orElseThrow(() -> new RuntimeException("Entity missing DomesticatedCapability."));
            if (domesticated.getAndUpdate(gameTime)) {
                return true;
            }
            boolean isTempted = animal.f_21345_.m_25386_().anyMatch(g -> g.m_26015_() instanceof TemptGoal);
            if (isTempted) {
                domesticated.setWithExpiry(level.m_46467_(), null);
                return true;
            }
            boolean isLeashed = animal.m_21523_();
            if (isLeashed) {
                domesticated.setWithExpiry(level.m_46467_(), null);
                return true;
            }
            boolean isFenced = BlockPos.m_121921_((AABB)new AABB(entity.m_20183_()).m_82377_(8.0, 4.0, 8.0)).anyMatch(bp -> Objects.requireNonNull(IProtectedBlocksCapability.get((Level)level, bp)).isProtectedBlock((BlockPos)bp, level.m_8055_(bp)) && (level.m_8055_(bp).m_204336_(Tags.Blocks.FENCES) || level.m_8055_(bp).m_204336_(Tags.Blocks.FENCE_GATES)));
            if (isFenced) {
                domesticated.setWithExpiry(level.m_46467_(), null);
                return true;
            }
        }
        return false;
    }
}

