/*
 * Decompiled with CFR 0.152.
 */
package com.metropolize.mtz_companions.entity.behaviors;

import com.metropolize.mtz_companions.core.MetropolizeBlockPos;
import com.metropolize.mtz_companions.entity.ServerCompanionEntity;
import com.metropolize.mtz_companions.entity.data.memories.MemoryModuleTypes;
import com.metropolize.mtz_companions.navigation.MtzWalkTarget;
import com.metropolize.mtz_companions.utils.BlockPlacementUtils;
import com.metropolize.mtzcharacterengine.api.core.behaviour.ExtendedBehaviour;
import com.metropolize.mtzcharacterengine.util.BrainUtils;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

@ParametersAreNonnullByDefault
public class SetPlacementTarget<E extends ServerCompanionEntity>
extends ExtendedBehaviour<E> {
    private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.of((Object[])new Pair[]{Pair.of((Object)((MemoryModuleType)MemoryModuleTypes.BLOCK_PLACE_ITEM.get()), (Object)MemoryStatus.VALUE_PRESENT), Pair.of((Object)((MemoryModuleType)MemoryModuleTypes.BLOCK_PLACE_POS.get()), (Object)MemoryStatus.REGISTERED), Pair.of((Object)((MemoryModuleType)MemoryModuleTypes.MAINHAND_TARGET.get()), (Object)MemoryStatus.REGISTERED), Pair.of((Object)MemoryModuleType.f_26371_, (Object)MemoryStatus.REGISTERED), Pair.of((Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.REGISTERED)});
    protected BiFunction<E, BlockPos, Float> speedModifier = (entity, targetPos) -> Float.valueOf(1.0f);
    protected BlockPos target = null;
    protected BlockItem item = null;

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, E entity) {
        Item itemToPlace = ((ItemStack)BrainUtils.getMemory(entity, (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.BLOCK_PLACE_ITEM.get()))).m_41720_();
        if (!(itemToPlace instanceof BlockItem)) {
            BrainUtils.clearMemory(entity, (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.BLOCK_PLACE_ITEM.get()));
            return false;
        }
        BlockItem blockItem = (BlockItem)itemToPlace;
        Optional<BlockPos> blockPosTarget = SetPlacementTarget.getEmptyVisibleBlock((Level)level, entity, blockItem);
        if (blockPosTarget.isEmpty()) {
            return false;
        }
        this.target = blockPosTarget.get();
        this.item = blockItem;
        return true;
    }

    protected static Optional<BlockPos> getEmptyVisibleBlock(Level level, ServerCompanionEntity entity, BlockItem itemToPlace) {
        int blockReach = (int)entity.getBlockReach();
        Vec3i front = entity.m_6350_().m_122436_().m_142393_(blockReach);
        Vec3i side = entity.m_6350_().m_122427_().m_122436_().m_142393_(blockReach);
        List<BlockPos> blocks = BlockPos.m_121990_((BlockPos)entity.m_20183_().m_121996_(side.m_121955_(front)).m_6625_(blockReach), (BlockPos)entity.m_20183_().m_121955_(side.m_121955_(front)).m_6630_(blockReach)).map(BlockPos::m_7949_).filter(blockPos -> !level.m_151570_(blockPos)).toList();
        return blocks.stream().filter(blockPos -> BlockPlacementUtils.canPlace(entity, itemToPlace, blockPos) && BlockPlacementUtils.getSupportingDirection(entity, level, new MetropolizeBlockPos((BlockPos)blockPos)) != null && entity.hasLineOfSight((BlockPos)blockPos, false)).min(Comparator.comparingDouble(a -> a.m_203193_((Position)entity.m_20182_())));
    }

    protected void start(E entity) {
        BrainUtils.setMemory(entity, (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.BLOCK_PLACE_POS.get()), (Object)this.target);
        BrainUtils.setMemory(entity, (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.MAINHAND_TARGET.get()), (Object)new ItemStack((ItemLike)this.item));
        BrainUtils.setMemory(entity, (MemoryModuleType)MemoryModuleType.f_26371_, (Object)new BlockPosTracker(this.target));
        BrainUtils.setMemory(entity, (MemoryModuleType)MemoryModuleType.f_26370_, (Object)((Object)new MtzWalkTarget(this.target, this.speedModifier.apply(entity, this.target).floatValue(), entity.getBlockReach())));
    }

    protected void stop(E entity) {
        this.target = null;
    }

    @FunctionalInterface
    protected static interface BlockPlacementSelector {
        public BlockPos apply(Level var1, ServerCompanionEntity var2);
    }
}

