/*
 * Decompiled with CFR 0.152.
 */
package com.metropolize.mtz_companions.entity.behaviors;

import com.metropolize.mtz_companions.core.MetropolizeBlockPos;
import com.metropolize.mtz_companions.entity.ServerCompanionEntity;
import com.metropolize.mtz_companions.entity.data.memories.MemoryModuleTypes;
import com.metropolize.mtz_companions.navigation.MtzWalkTarget;
import com.metropolize.mtzcharacterengine.MtzBrainOwner;
import com.metropolize.mtzcharacterengine.api.core.behaviour.ExtendedBehaviour;
import com.metropolize.mtzcharacterengine.util.BrainUtils;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.phys.Vec3;

@ParametersAreNonnullByDefault
public class SetPlayerWalkTarget<E extends LivingEntity>
extends ExtendedBehaviour<E> {
    private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.of((Object[])new Pair[]{Pair.of((Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.REGISTERED), Pair.of((Object)MemoryModuleType.f_26371_, (Object)MemoryStatus.REGISTERED), Pair.of((Object)MemoryModuleType.f_26367_, (Object)MemoryStatus.VALUE_PRESENT)});
    protected BiFunction<E, Vec3, Float> speedModifier = (entity, targetPos) -> Float.valueOf(1.0f);
    protected Player target = null;
    protected BiPredicate<E, Player> predicate = (entity, player) -> {
        if (player instanceof ServerCompanionEntity) {
            return false;
        }
        MtzWalkTarget tether = (MtzWalkTarget)((Object)((Object)BrainUtils.getMemory((MtzBrainOwner)((MtzBrainOwner)entity), (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.PATHFINDING_TETHER.get()))));
        if (tether != null) {
            return tether.isReached((ServerCompanionEntity)entity, new MetropolizeBlockPos(player.m_20183_()));
        }
        return true;
    };
    protected int closeEnoughDistance = 2;

    public SetPlayerWalkTarget<E> speedMod(BiFunction<E, Vec3, Float> fun) {
        this.speedModifier = fun;
        return this;
    }

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    public SetPlayerWalkTarget<E> predicate(BiPredicate<E, Player> predicate) {
        this.predicate = predicate;
        return this;
    }

    protected boolean m_6114_(ServerLevel level, E entity) {
        List nearbyPlayers = (List)BrainUtils.getMemory((MtzBrainOwner)((MtzBrainOwner)entity), (MemoryModuleType)MemoryModuleType.f_26367_);
        if (nearbyPlayers == null) {
            return false;
        }
        for (Player player : nearbyPlayers) {
            if (!this.predicate.test(entity, player)) continue;
            this.target = player;
            break;
        }
        return this.target != null;
    }

    protected void start(E entity) {
        Boat boat;
        Entity entity2 = this.target.m_20202_();
        if (entity2 instanceof Boat && (boat = (Boat)entity2).m_20363_(entity)) {
            BrainUtils.clearMemory((MtzBrainOwner)((MtzBrainOwner)entity), (MemoryModuleType)MemoryModuleType.f_26370_);
            return;
        }
        BrainUtils.setMemory((MtzBrainOwner)((MtzBrainOwner)entity), (MemoryModuleType)MemoryModuleType.f_26371_, (Object)new EntityTracker((Entity)this.target, true));
        BrainUtils.setMemory((MtzBrainOwner)((MtzBrainOwner)entity), (MemoryModuleType)MemoryModuleType.f_26370_, (Object)((Object)new MtzWalkTarget((Entity)this.target, this.speedModifier.apply(entity, this.target.m_20182_()).floatValue(), (double)this.closeEnoughDistance)));
    }

    protected void stop(E entity) {
        if (this.target.m_20270_(entity) < (float)this.closeEnoughDistance) {
            BrainUtils.clearMemory((MtzBrainOwner)((MtzBrainOwner)entity), (MemoryModuleType)MemoryModuleType.f_26370_);
        }
        this.target = null;
    }
}

