/*
 * Decompiled with CFR 0.152.
 */
package com.metropolize.mtz_companions.entity.behaviors;

import com.metropolize.mtz_companions.entity.CompanionContainer;
import com.metropolize.mtz_companions.entity.ServerCompanionEntity;
import com.metropolize.mtz_companions.entity.data.memories.MemoryModuleTypes;
import com.metropolize.mtzcharacterengine.api.core.behaviour.ExtendedBehaviour;
import com.metropolize.mtzcharacterengine.util.BrainUtils;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.item.ItemStack;

@ParametersAreNonnullByDefault
public class SetWeaponEquipTarget<E extends ServerCompanionEntity>
extends ExtendedBehaviour<E> {
    private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.of((Object[])new Pair[]{Pair.of((Object)((MemoryModuleType)MemoryModuleTypes.MAINHAND_TARGET.get()), (Object)MemoryStatus.REGISTERED)});
    protected Predicate<ItemStack> itemStackPredicate = itemStack -> !itemStack.m_41619_();

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    private static double getDamage(ItemStack itemStack) {
        Collection damageAttributes = itemStack.m_41720_().getAttributeModifiers(EquipmentSlot.MAINHAND, itemStack).get((Object)Attributes.f_22281_);
        if (damageAttributes.isEmpty()) {
            return 0.0;
        }
        return ((AttributeModifier)damageAttributes.toArray()[0]).m_22218_();
    }

    protected void start(E entity) {
        CompanionContainer inventory = ((ServerCompanionEntity)entity).getInventory();
        ItemStack toEquip = inventory.m_8020_(0);
        double maxDamage = 0.0;
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack itemStack = inventory.m_8020_(i);
            if (!this.itemStackPredicate.test(itemStack) || !(SetWeaponEquipTarget.getDamage(itemStack) > maxDamage)) continue;
            toEquip = itemStack;
            maxDamage = SetWeaponEquipTarget.getDamage(toEquip);
        }
        BrainUtils.setMemory(entity, (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.MAINHAND_TARGET.get()), (Object)toEquip);
    }
}

