/*
 * Decompiled with CFR 0.152.
 */
package com.metropolize.mtz_companions.entity.behaviors;

import com.metropolize.mtz_companions.entity.ServerCompanionEntity;
import com.metropolize.mtz_companions.entity.data.memories.MemoryModuleTypes;
import com.metropolize.mtz_companions.entity.sensors.NearestBedSensor;
import com.metropolize.mtzcharacterengine.api.core.behaviour.ExtendedBehaviour;
import com.metropolize.mtzcharacterengine.util.BrainUtils;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.ForgeMod;

@ParametersAreNonnullByDefault
public class SleepAtBedTarget<E extends ServerCompanionEntity>
extends ExtendedBehaviour<E> {
    private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.of((Object[])new Pair[]{Pair.of((Object)MemoryModuleType.f_26328_, (Object)MemoryStatus.REGISTERED), Pair.of(MemoryModuleTypes.BED_TARGET.get(), (Object)MemoryStatus.VALUE_PRESENT), Pair.of((Object)((MemoryModuleType)MemoryModuleTypes.SLEEP_COOLING_DOWN.get()), (Object)MemoryStatus.VALUE_ABSENT)});
    protected BlockPos target = null;
    protected ServerLevel level = null;

    public SleepAtBedTarget() {
        this.runFor(entity -> Integer.MAX_VALUE);
    }

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, E entity) {
        if (entity.m_5803_() || level.m_46461_()) {
            return false;
        }
        BlockPos blockPos = (BlockPos)BrainUtils.getMemory(entity, MemoryModuleTypes.BED_TARGET.get());
        if (!((ServerCompanionEntity)entity).hasLineOfSight(blockPos, false) || !NearestBedSensor.availableBedPredicate.test((ServerCompanionEntity)entity, blockPos)) {
            return false;
        }
        BlockState blockState = level.m_8055_(blockPos);
        if (!(blockState.m_60734_() instanceof BedBlock)) {
            return false;
        }
        double dist = Math.sqrt(entity.m_20275_((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_()));
        double reach = entity.m_21133_((Attribute)ForgeMod.BLOCK_REACH.get());
        if (reach < dist) {
            return false;
        }
        this.target = blockPos;
        this.level = level;
        return true;
    }

    protected void start(E entity) {
        this.kickVillagerOutOfBed();
        ((ServerCompanionEntity)entity).m_9158_((ResourceKey<Level>)entity.m_9236_().m_46472_(), this.target, entity.m_146908_(), false, true);
        entity.m_5802_(this.target);
        BrainUtils.setMemory(entity, (MemoryModuleType)MemoryModuleType.f_26328_, (Object)entity.m_9236_().m_46467_());
        BrainUtils.clearMemory(entity, (MemoryModuleType)MemoryModuleType.f_26370_);
    }

    protected void tick(E entity) {
        entity.m_5802_(this.target);
        this.level.m_8904_().m_27154_(this.target);
        this.level.m_8904_().m_217946_(holder -> holder.m_203565_(PoiTypes.f_218060_), (holder, blockPos) -> blockPos.equals((Object)this.target), this.target, 1);
        super.tick(entity);
    }

    protected boolean shouldKeepRunning(E entity) {
        return ((ServerCompanionEntity)entity).canContinueSleep();
    }

    protected void stop(E entity) {
        if (this.level.m_8904_().m_27091_(this.target, key -> true)) {
            this.level.m_8904_().m_27154_(this.target);
        }
        ((ServerCompanionEntity)entity).m_5796_();
        BrainUtils.setMemory(entity, (MemoryModuleType)MemoryModuleType.f_26329_, (Object)entity.m_9236_().m_46467_());
        this.target = null;
    }

    private void kickVillagerOutOfBed() {
        List villagers = this.level.m_6443_(Villager.class, new AABB(this.target), LivingEntity::m_5803_);
        if (!villagers.isEmpty()) {
            ((Villager)villagers.get(0)).m_5796_();
        }
    }
}

