/*
 * Decompiled with CFR 0.152.
 */
package com.metropolize.mtz_companions.entity.behaviors;

import com.metropolize.mtz_companions.entity.ServerCompanionEntity;
import com.metropolize.mtz_companions.entity.data.memories.MemoryModuleTypes;
import com.metropolize.mtz_companions.utils.ContainerUtils;
import com.metropolize.mtzcharacterengine.api.core.behaviour.ExtendedBehaviour;
import com.metropolize.mtzcharacterengine.util.BrainUtils;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import org.jetbrains.annotations.NotNull;

public class StoreInChestTarget<E extends ServerCompanionEntity>
extends ExtendedBehaviour<E> {
    private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.of((Object[])new Pair[]{Pair.of(MemoryModuleTypes.INTERACTION_TARGET.get(), (Object)MemoryStatus.VALUE_PRESENT)});
    protected BlockPos target = null;
    protected ServerLevel level = null;
    protected final Deque<ItemStack> itemsToStore = new ArrayDeque<ItemStack>();
    private static final int TICKS_PER_STACK = 10;
    private int tickCount = 0;

    public StoreInChestTarget() {
        this.noTimeout();
    }

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    protected boolean checkExtraStartConditions(@NotNull ServerLevel level, @NotNull E entity) {
        BlockPos blockPos = (BlockPos)BrainUtils.getMemory(entity, MemoryModuleTypes.INTERACTION_TARGET.get());
        if (blockPos == null || !((ServerCompanionEntity)entity).hasLineOfSight(blockPos, false)) {
            return false;
        }
        BlockState blockState = level.m_8055_(blockPos);
        if (!(blockState.m_60734_() instanceof ChestBlock) || ChestBlock.m_51508_((LevelAccessor)level, (BlockPos)blockPos)) {
            return false;
        }
        double dist = Math.sqrt(entity.m_20238_(blockPos.m_252807_()));
        double reach = entity.m_21133_((Attribute)ForgeMod.BLOCK_REACH.get());
        if (reach < dist) {
            return false;
        }
        Set<ItemStack> itemsToStore = ContainerUtils.getItemsToStoreInChest(entity, (ChestBlockEntity)level.m_7702_(blockPos));
        if (itemsToStore.isEmpty()) {
            return false;
        }
        this.target = blockPos;
        this.level = level;
        this.itemsToStore.addAll(itemsToStore);
        return true;
    }

    protected void start(E entity) {
        InteractionResult result = this.level.m_8055_(this.target).m_60664_((Level)this.level, entity, InteractionHand.MAIN_HAND, new BlockHitResult(Vec3.m_82512_((Vec3i)this.target), Direction.NORTH, this.target, true));
        entity.m_6674_(InteractionHand.MAIN_HAND);
        this.tickCount = 0;
    }

    protected void tick(E entity) {
        ItemStack itemStack;
        int slot;
        if (this.tickCount != 10) {
            ++this.tickCount;
            return;
        }
        do {
            if (this.itemsToStore.isEmpty()) {
                return;
            }
            itemStack = this.itemsToStore.pop();
        } while ((slot = ((ServerCompanionEntity)entity).getInventory().m_36030_(itemStack)) == -1);
        ChestBlockEntity blockEntity = (ChestBlockEntity)this.level.m_7702_(this.target);
        for (int i = 0; i < blockEntity.m_6643_() && !(itemStack = ContainerUtils.tryAddItem((Container)blockEntity, itemStack, i)).m_41619_(); ++i) {
        }
        ((ServerCompanionEntity)entity).getInventory().m_6836_(slot, itemStack);
        this.tickCount = 0;
    }

    protected void stop(E entity) {
        entity.m_6674_(InteractionHand.MAIN_HAND);
        entity.m_9230_();
        if (((ServerCompanionEntity)entity).getOverrideActivity() != null) {
            ((ServerCompanionEntity)entity).setOverrideActivity(null);
        }
        BrainUtils.clearMemory(entity, MemoryModuleTypes.INTERACTION_TARGET.get());
        this.target = null;
        this.level = null;
        this.itemsToStore.clear();
        this.tickCount = 0;
    }

    protected boolean shouldKeepRunning(E entity) {
        BlockState blockState = this.level.m_8055_(this.target);
        if (!(blockState.m_60734_() instanceof ChestBlock) || ChestBlock.m_51508_((LevelAccessor)this.level, (BlockPos)this.target)) {
            return false;
        }
        return !this.itemsToStore.isEmpty();
    }
}

