/*
 * Decompiled with CFR 0.152.
 */
package com.metropolize.mtz_companions.entity.behaviors.core;

import com.metropolize.mtz_companions.entity.CompanionContainer;
import com.metropolize.mtz_companions.entity.ServerCompanionEntity;
import com.metropolize.mtzcharacterengine.api.core.behaviour.ExtendedBehaviour;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.common.Tags;

@ParametersAreNonnullByDefault
public class EquipArmor<E extends ServerCompanionEntity>
extends ExtendedBehaviour<E> {
    private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.of();
    protected Predicate<ItemStack> itemStackPredicate = itemStack -> LivingEntity.m_147233_((ItemStack)itemStack).m_254934_() && !itemStack.m_41619_() || itemStack.m_204117_(Tags.Items.TOOLS_SHIELDS);
    protected Predicate<E> predicate = entity -> entity.getInventory().m_216874_(itemStack -> this.itemStackPredicate.test((ItemStack)itemStack));
    protected Set<ItemStack> target = null;

    private static double getArmorValue(ItemStack itemStack) {
        try {
            ArmorItem item = (ArmorItem)itemStack.m_41720_();
            int enchantLevels = EnchantmentHelper.m_44831_((ItemStack)itemStack).values().stream().reduce(0, Integer::sum);
            return (float)item.m_40404_() + (float)enchantLevels * 0.1f;
        }
        catch (ClassCastException e) {
            return 0.0;
        }
    }

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, E entity) {
        if (!this.predicate.test(entity)) {
            return false;
        }
        HashSet<ItemStack> armorToEquip = new HashSet<ItemStack>();
        HashMap<EquipmentSlot, Double> maxArmorValues = new HashMap<EquipmentSlot, Double>();
        for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
            ItemStack currentArmor;
            if (!equipmentSlot.m_254934_() || (currentArmor = ((ServerCompanionEntity)entity).m_6844_(equipmentSlot)).m_41619_()) continue;
            maxArmorValues.put(equipmentSlot, EquipArmor.getArmorValue(currentArmor));
        }
        CompanionContainer inventory = ((ServerCompanionEntity)entity).getInventory();
        for (int i = 0; i < inventory.f_35974_.size(); ++i) {
            EquipmentSlot equipmentSlot;
            ItemStack itemStack = inventory.m_8020_(i);
            if (!this.itemStackPredicate.test(itemStack)) continue;
            if (itemStack.m_204117_(Tags.Items.TOOLS_SHIELDS) && !entity.m_21206_().m_204117_(Tags.Items.TOOLS_SHIELDS)) {
                armorToEquip.add(itemStack);
                continue;
            }
            equipmentSlot = LivingEntity.m_147233_((ItemStack)itemStack);
            Double maxArmor = (Double)maxArmorValues.get(equipmentSlot);
            Double armor = EquipArmor.getArmorValue(itemStack);
            if (maxArmor != null && !(armor > maxArmor)) continue;
            maxArmorValues.put(equipmentSlot, armor);
            armorToEquip.add(itemStack);
        }
        this.target = armorToEquip;
        return true;
    }

    protected void start(E entity) {
        for (ItemStack armor : this.target) {
            ((ServerCompanionEntity)entity).m_8061_(LivingEntity.m_147233_((ItemStack)armor), armor);
        }
    }

    protected void stop(E entity) {
        this.target = null;
    }
}

