/*
 * Decompiled with CFR 0.152.
 */
package com.metropolize.mtz_companions.entity.behaviors.core;

import com.metropolize.mtz_companions.entity.ServerCompanionEntity;
import com.metropolize.mtz_companions.entity.data.memories.MemoryModuleTypes;
import com.metropolize.mtzcharacterengine.api.core.behaviour.ExtendedBehaviour;
import com.metropolize.mtzcharacterengine.util.BrainUtils;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.item.ItemStack;

@ParametersAreNonnullByDefault
public class EquipHandTarget<E extends ServerCompanionEntity>
extends ExtendedBehaviour<E> {
    private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.of((Object[])new Pair[]{Pair.of((Object)((MemoryModuleType)MemoryModuleTypes.MAINHAND_TARGET.get()), (Object)MemoryStatus.REGISTERED)});
    protected EquipmentSlot hand = EquipmentSlot.MAINHAND;
    protected ItemStack target = null;

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    public EquipHandTarget<E> offhand() {
        this.hand = EquipmentSlot.OFFHAND;
        return this;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, E entity) {
        ItemStack equipTarget;
        ItemStack itemStack = equipTarget = this.hand == EquipmentSlot.MAINHAND ? (ItemStack)BrainUtils.getMemory(entity, (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.MAINHAND_TARGET.get())) : (ItemStack)BrainUtils.getMemory(entity, (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.OFFHAND_TARGET.get()));
        if (equipTarget != null && (((ServerCompanionEntity)entity).getInventory().m_36030_(equipTarget) != -1 || equipTarget.m_41619_())) {
            this.target = equipTarget;
        }
        return this.target != null;
    }

    protected void start(E entity) {
        if (this.hand == EquipmentSlot.MAINHAND) {
            ((ServerCompanionEntity)entity).getInventory().m_36012_(this.target);
        } else {
            ((ServerCompanionEntity)entity).m_8061_(EquipmentSlot.OFFHAND, this.target);
        }
    }

    protected void stop(E entity) {
        this.target = null;
        BrainUtils.clearMemory(entity, (MemoryModuleType)(this.hand == EquipmentSlot.MAINHAND ? (MemoryModuleType)MemoryModuleTypes.MAINHAND_TARGET.get() : (MemoryModuleType)MemoryModuleTypes.OFFHAND_TARGET.get()));
    }
}

