/*
 * Decompiled with CFR 0.152.
 */
package com.metropolize.mtz_companions.entity.behaviors.core;

import com.metropolize.mtz_companions.core.MetropolizeBlockPos;
import com.metropolize.mtz_companions.entity.ServerCompanionEntity;
import com.metropolize.mtz_companions.entity.data.memories.MemoryModuleTypes;
import com.metropolize.mtz_companions.navigation.path.PathNodeContext;
import com.metropolize.mtzcharacterengine.api.core.behaviour.ExtendedBehaviour;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.StandingAndWallBlockItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

@ParametersAreNonnullByDefault
public class PlaceTorch<E extends ServerCompanionEntity>
extends ExtendedBehaviour<E> {
    private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.of((Object[])new Pair[]{Pair.of(MemoryModuleTypes.PATH.get(), (Object)MemoryStatus.REGISTERED)});
    protected BlockPos adjacentBlock = null;
    private ItemStack torchStack = null;
    private BlockPos targetPos = null;

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, E entity) {
        if (((ServerCompanionEntity)entity).getBlockBreakControl().wasBreaking() || ((ServerCompanionEntity)entity).getBlockPlaceControl().hasPlacementTarget() || ((ServerCompanionEntity)entity).getExplorationData().getNearbyCave() == null || level.m_45524_(entity.m_20183_(), level.m_7445_()) >= 2) {
            return false;
        }
        ItemStack torches = ((ServerCompanionEntity)entity).getInventory().findFirstItemSlot(Items.f_42000_);
        if (torches == null) {
            return false;
        }
        this.torchStack = torches;
        Vec3i front = entity.m_6350_().m_122436_();
        Vec3i side = entity.m_6350_().m_122427_().m_122436_();
        List<BlockPos> reachable = BlockPos.m_121990_((BlockPos)entity.m_20183_().m_121996_(side.m_121955_(front).m_6625_(1)), (BlockPos)entity.m_20183_().m_121955_(side.m_121955_(front)).m_6630_(1)).map(BlockPos::m_7949_).toList();
        for (BlockPos blockPos : reachable) {
            MetropolizeBlockPos supportingPos = PlaceTorch.getValidSupportingPos(level, entity, new MetropolizeBlockPos(blockPos));
            if (supportingPos == null) continue;
            this.targetPos = blockPos;
            this.adjacentBlock = supportingPos;
            break;
        }
        return this.targetPos != null;
    }

    @Nullable
    private static MetropolizeBlockPos getValidSupportingPos(ServerLevel level, ServerCompanionEntity entity, MetropolizeBlockPos pos) {
        PathNodeContext pathNodeContext;
        if (!level.m_46859_((BlockPos)pos) || !level.m_6425_((BlockPos)pos).m_76178_()) {
            return null;
        }
        PathNodeContext pathNodeContext2 = pathNodeContext = entity.getPathFinder().getPath() != null ? entity.getPathFinder().getPath().getLastNode().pathNodeContext : null;
        if (pathNodeContext != null && pathNodeContext.blocksPlaced.contains((Object)pos)) {
            return null;
        }
        for (Direction d : Direction.m_122382_((Entity)entity)) {
            MetropolizeBlockPos supportingPos = pos.relative(d);
            BlockState adjacentBlockState = level.m_8055_((BlockPos)supportingPos);
            if (pathNodeContext != null && pathNodeContext.blocksBroken.contains((Object)supportingPos) || !adjacentBlockState.m_60783_((BlockGetter)level, (BlockPos)supportingPos, d.m_122424_()) || !entity.hasLineOfSight(supportingPos, false)) continue;
            return supportingPos;
        }
        return null;
    }

    protected void start(E entity) {
        ((ServerCompanionEntity)entity).m_8061_(EquipmentSlot.MAINHAND, this.torchStack);
        BlockPlaceContext context = new BlockPlaceContext(entity, InteractionHand.MAIN_HAND, this.torchStack, new BlockHitResult(this.adjacentBlock.m_252807_(), Direction.m_122378_((int)(this.targetPos.m_123341_() - this.adjacentBlock.m_123341_()), (int)(this.targetPos.m_123342_() - this.adjacentBlock.m_123342_()), (int)(this.targetPos.m_123343_() - this.adjacentBlock.m_123343_())), this.adjacentBlock, false));
        entity.m_6674_(InteractionHand.MAIN_HAND);
        ((StandingAndWallBlockItem)Items.f_42000_).m_40576_(context);
    }

    protected void stop(E entity) {
        this.targetPos = null;
        this.adjacentBlock = null;
        this.torchStack = null;
    }
}

