/*
 * Decompiled with CFR 0.152.
 */
package com.metropolize.mtz_companions.entity.behaviors.core;

import com.metropolize.mtz_companions.core.ServerCompanionManager;
import com.metropolize.mtz_companions.entity.ServerCompanionEntity;
import com.metropolize.mtz_companions.entity.data.memories.MemoryModuleTypes;
import com.metropolize.mtzcharacterengine.api.core.behaviour.ExtendedBehaviour;
import com.metropolize.mtzcharacterengine.util.BrainUtils;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.level.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetRandomizedMemories<E extends ServerCompanionEntity>
extends ExtendedBehaviour<E> {
    private static final Logger log = LoggerFactory.getLogger(SetRandomizedMemories.class);
    private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.of((Object[])new Pair[]{Pair.of((Object)((MemoryModuleType)MemoryModuleTypes.NEXT_EXPLORE_DELAY_TICKS.get()), (Object)MemoryStatus.REGISTERED), Pair.of((Object)((MemoryModuleType)MemoryModuleTypes.WANTS_TO_EXPLORE.get()), (Object)MemoryStatus.REGISTERED), Pair.of((Object)((MemoryModuleType)MemoryModuleTypes.LAST_EXPLORE_TIME.get()), (Object)MemoryStatus.REGISTERED)});

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    protected void start(E entity) {
        BrainUtils.setMemory(entity, (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.NEXT_EXPLORE_DELAY_TICKS.get()), (Object)SetRandomizedMemories.generateTimeUntilNextExplore(entity));
    }

    protected void tick(E entity) {
        Level level = entity.m_9236_();
        if (!BrainUtils.hasMemory(entity, (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.WANTS_TO_EXPLORE.get()))) {
            long lastExplored = (Long)BrainUtils.memoryOrDefault(entity, (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.LAST_EXPLORE_TIME.get()), () -> 0L);
            if (level.m_46467_() >= (long)((Integer)BrainUtils.memoryOrDefault(entity, (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.NEXT_EXPLORE_DELAY_TICKS.get()), () -> 0)).intValue() + lastExplored) {
                ((ServerCompanionEntity)entity).sendChatMessage((Component)Component.m_237115_((String)"companion.chat.exploration.started"));
                int exploreDurationTicks = (int)Math.max(6000.0, this.sampleSkewedNormal(entity.m_217043_(), 20, 3, 5.0f) * 2400.0);
                log.info("Starting exploration for {} ticks.", (Object)exploreDurationTicks);
                BrainUtils.setForgettableMemory(entity, (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.WANTS_TO_EXPLORE.get()), (Object)true, (int)exploreDurationTicks);
                int nextExploreTicks = SetRandomizedMemories.generateTimeUntilNextExplore(entity);
                log.info("Next exploration will occur in {} ticks.", (Object)nextExploreTicks);
                BrainUtils.setMemory(entity, (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.NEXT_EXPLORE_DELAY_TICKS.get()), (Object)nextExploreTicks);
            }
        }
        super.tick(entity);
    }

    protected boolean m_7773_(long gameTime) {
        return false;
    }

    protected boolean shouldKeepRunning(E entity) {
        return true;
    }

    public static int generateTimeUntilNextExplore(LivingEntity entity) {
        double normalSample = Math.max(0.0, entity.m_217043_().m_188583_() * 20000.0 + 60000.0);
        double x = ServerCompanionManager.getExplorationFrequency((ServerLevel)entity.m_9236_());
        double exploreFrequencyCoeff = (1.0 - x) / x;
        return (int)(normalSample * exploreFrequencyCoeff);
    }

    private double sampleSkewedNormal(RandomSource random, int mean, int variance, float skewness) {
        double x1 = random.m_188583_() * (double)variance;
        double x2 = random.m_188583_() * (double)variance + (double)mean;
        double delta = (double)skewness / Math.sqrt(1.0 + Math.pow(skewness, 2.0));
        return delta * Math.abs(x1) + x2 * Math.sqrt(1.0 - Math.pow(delta, 2.0));
    }
}

