/*
 * Decompiled with CFR 0.152.
 */
package com.metropolize.mtz_companions.entity.behaviors.core;

import com.metropolize.mtz_companions.entity.ServerCompanionEntity;
import com.metropolize.mtz_companions.entity.data.memories.MemoryModuleTypes;
import com.metropolize.mtzcharacterengine.api.core.behaviour.ExtendedBehaviour;
import com.metropolize.mtzcharacterengine.util.BrainUtils;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.BiPredicate;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.item.ItemStack;

@ParametersAreNonnullByDefault
public class UseMainHandItem<E extends ServerCompanionEntity>
extends ExtendedBehaviour<E> {
    private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.of((Object[])new Pair[]{Pair.of((Object)((MemoryModuleType)MemoryModuleTypes.USE_TARGET.get()), (Object)MemoryStatus.REGISTERED)});
    protected BiPredicate<E, ItemStack> predicate = (entity, item) -> true;
    private ItemStack useTarget = null;

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    protected boolean shouldKeepRunning(E entity) {
        if (this.useTarget != entity.m_21205_()) {
            return false;
        }
        return this.useTarget != null && !this.useTarget.m_41619_() && entity.m_21212_() > 0;
    }

    protected boolean m_7773_(long gameTime) {
        return false;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, E entity) {
        ItemStack itemToUse = (ItemStack)BrainUtils.getMemory(entity, (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.USE_TARGET.get()));
        if (itemToUse != null && entity.m_21205_() == itemToUse) {
            if (this.predicate.test(entity, itemToUse)) {
                this.useTarget = itemToUse;
            } else {
                BrainUtils.clearMemory(entity, (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.USE_TARGET.get()));
                this.useTarget = null;
            }
        }
        return this.useTarget != null;
    }

    protected void start(E entity) {
        if (this.useTarget != null) {
            ((ServerCompanionEntity)entity).m_6672_(InteractionHand.MAIN_HAND);
        }
    }

    protected void stop(E entity) {
        if (this.useTarget != null && entity.m_21205_() == this.useTarget) {
            ((ServerCompanionEntity)entity).m_5810_();
            BrainUtils.clearMemory(entity, (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.MAINHAND_TARGET.get()));
        }
        BrainUtils.clearMemory(entity, (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.USE_TARGET.get()));
        this.useTarget = null;
    }
}

