/*
 * Decompiled with CFR 0.152.
 */
package com.metropolize.mtz_companions.entity.behaviors.movement;

import com.metropolize.mtz_companions.core.MetropolizeBlockPos;
import com.metropolize.mtz_companions.entity.ServerCompanionEntity;
import com.metropolize.mtz_companions.entity.data.memories.MemoryModuleTypes;
import com.metropolize.mtz_companions.navigation.move.BuildMove;
import com.metropolize.mtz_companions.navigation.move.DescendMove;
import com.metropolize.mtz_companions.navigation.move.Move;
import com.metropolize.mtz_companions.navigation.move.Moves;
import com.metropolize.mtz_companions.navigation.move.SwimMove;
import com.metropolize.mtz_companions.navigation.path.Path;
import com.metropolize.mtz_companions.navigation.path.PathNode;
import com.metropolize.mtz_companions.navigation.path.PathNodeContext;
import com.metropolize.mtz_companions.navigation.utils.MovementUtils;
import com.metropolize.mtzcharacterengine.api.core.behaviour.ExtendedBehaviour;
import com.metropolize.mtzcharacterengine.util.BrainUtils;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class MoveAlongPath<E extends ServerCompanionEntity>
extends ExtendedBehaviour<E> {
    private static final Logger log = LogUtils.getLogger();
    private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.of((Object[])new Pair[]{Pair.of(MemoryModuleTypes.PATH.get(), (Object)MemoryStatus.REGISTERED), Pair.of((Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.REGISTERED)});
    public static final EntityDimensions SWIMMING_DIMENSIONS = EntityDimensions.m_20395_((float)0.6f, (float)0.6f);
    public static final float SPRINT_DISTANCE = 1.5f;
    protected static final float MIN_DISPLACEMENT_SQR = 0.1f;
    protected Path path = null;
    protected PathNode targetNode = null;
    protected int targetNodeIdx = -1;
    protected long stuckTicks = 0L;

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    protected boolean checkExtraStartConditions(@NotNull ServerLevel level, E entity) {
        this.path = ((ServerCompanionEntity)entity).getPathFinder().getPath();
        return this.path != null && !this.path.isAtEnd((ServerCompanionEntity)entity) && !entity.m_5803_();
    }

    protected void start(E entity) {
        BrainUtils.setMemory(entity, MemoryModuleTypes.PATH.get(), (Object)this.path);
        PathNode closestNode = this.path.getClosestPathNode(((ServerCompanionEntity)entity).mtzPosition());
        List<PathNode> nodes = this.path.nodes();
        this.targetNodeIdx = nodes.indexOf(closestNode);
        if (this.targetNodeIdx < nodes.size() - 1) {
            ++this.targetNodeIdx;
        }
        this.targetNode = nodes.get(this.targetNodeIdx);
        if (entity.m_20202_() != null && entity.m_20202_() instanceof Boat) {
            entity.m_8127_();
        }
    }

    protected void tick(E entity) {
        ServerLevel level;
        PathNode closest;
        Path pathfinderPath = ((ServerCompanionEntity)entity).getPathFinder().getPath();
        if (this.path != pathfinderPath && pathfinderPath != null) {
            this.path = pathfinderPath;
            this.start(entity);
        }
        ++this.stuckTicks;
        if (entity.m_20069_() && (closest = this.path.getClosestPathNode(((ServerCompanionEntity)entity).mtzPosition())).getCost() > this.targetNode.getCost() && (this.targetNode.getBlockPosToPlace() == null || !entity.m_9236_().m_46859_((BlockPos)this.targetNode.getBlockPosToPlace()))) {
            this.targetNode = closest;
            this.targetNodeIdx = this.path.nodes().indexOf(this.targetNode);
        }
        if (this.targetNode.isReached(entity.m_9236_(), ((ServerCompanionEntity)entity).mtzPosition())) {
            if (this.targetNode.equals(this.path.getLastNode())) {
                return;
            }
            ++this.targetNodeIdx;
            this.targetNode = this.path.getNode(this.targetNodeIdx);
            this.stuckTicks = 0L;
        }
        if (this.breakBlocks(level = (ServerLevel)entity.m_9236_(), entity)) {
            return;
        }
        this.setSprintingCrouching(entity);
        this.openDoors(entity);
        this.placeBlocks(level, entity);
        Move move = this.targetNode.getMove();
        if (move == null) {
            if (entity.m_6069_()) {
                this.doSwim(entity);
            } else {
                this.doMoveTo(level, entity);
            }
        } else if (move instanceof SwimMove && entity.m_20142_()) {
            this.doSwim(entity);
        } else {
            this.doMoveTo(level, entity);
        }
    }

    protected void stop(E entity) {
        if (this.path.isAtEnd((ServerCompanionEntity)entity)) {
            BrainUtils.clearMemory(entity, (MemoryModuleType)MemoryModuleType.f_26370_);
        }
        if (!entity.m_5803_()) {
            ((ServerCompanionEntity)entity).resetPose();
        }
        this.stuckTicks = 0L;
        this.path = null;
        this.targetNode = null;
        this.targetNodeIdx = 0;
        entity.m_7910_(0.0f);
        ((ServerCompanionEntity)entity).f_20900_ = 0.0f;
        ((ServerCompanionEntity)entity).f_20901_ = 0.0f;
        ((ServerCompanionEntity)entity).f_20902_ = 0.0f;
        BrainUtils.clearMemory(entity, MemoryModuleTypes.PATH.get());
    }

    protected boolean shouldKeepRunning(E entity) {
        if (this.stuckTicks > 100L) {
            log.warn("{}: Unstucking...", (Object)entity.m_7755_());
            BrainUtils.clearMemory(entity, (MemoryModuleType)MemoryModuleType.f_26370_);
            return false;
        }
        return !this.path.isAtEnd((ServerCompanionEntity)entity);
    }

    protected boolean m_7773_(long gameTime) {
        return false;
    }

    protected void setSprintingCrouching(E entity) {
        if (((ServerCompanionEntity)entity).m_264410_()) {
            boolean isFarEnough;
            boolean exitingWater;
            boolean bl = exitingWater = entity.m_20069_() && !entity.canStartSwimming() && this.targetNode.blockState.m_60819_().m_76178_();
            if (exitingWater) {
                ((ServerCompanionEntity)entity).getSprintControl().sprint();
                return;
            }
            boolean bl2 = isFarEnough = ((ServerCompanionEntity)entity).mtzPosition().m_82546_(this.path.getLastNode().pos).m_165925_() > 1.5;
            if (isFarEnough && !(this.targetNode.getMove() instanceof BuildMove)) {
                ((ServerCompanionEntity)entity).getSprintControl().sprint();
            }
        }
    }

    protected void openDoors(E entity) {
        BlockPos[] blockPositions;
        Level level = entity.m_9236_();
        for (BlockPos blockPos : blockPositions = new BlockPos[]{this.targetNode.blockPos, this.targetNode.blockPos.above()}) {
            BlockState blockState = level.m_8055_(blockPos);
            if (blockState.m_204336_(BlockTags.f_13095_) && !((Boolean)blockState.m_61143_((Property)DoorBlock.f_52727_)).booleanValue() && ((DoubleBlockHalf)blockState.m_61143_((Property)DoorBlock.f_52730_)).equals((Object)DoubleBlockHalf.LOWER)) {
                entity.m_6674_(InteractionHand.MAIN_HAND);
                ((DoorBlock)blockState.m_60734_()).m_153165_(entity, level, blockState, blockPos, true);
                continue;
            }
            Block block = blockState.m_60734_();
            if (!(block instanceof FenceGateBlock)) continue;
            FenceGateBlock fenceGateBlock = (FenceGateBlock)block;
            if (((Boolean)blockState.m_61143_((Property)FenceGateBlock.f_53341_)).booleanValue()) continue;
            entity.m_6674_(InteractionHand.MAIN_HAND);
            fenceGateBlock.m_6227_(blockState, level, blockPos, entity, InteractionHand.MAIN_HAND, null);
        }
    }

    protected boolean breakBlocks(ServerLevel level, E entity) {
        List<MetropolizeBlockPos> toBreak = this.targetNode.getBlocksToBreak().stream().filter(blockPos -> !MovementUtils.canPassThrough(new PathNodeContext((Level)level), blockPos, level.m_8055_((BlockPos)blockPos), true)).toList();
        if (!toBreak.isEmpty()) {
            entity.m_7910_(0.0f);
            ((ServerCompanionEntity)entity).f_20902_ = 0.0f;
            ((ServerCompanionEntity)entity).f_20900_ = 0.0f;
            ((ServerCompanionEntity)entity).getBlockBreakControl().breakBlock(level, toBreak.get(0), true);
            return true;
        }
        return false;
    }

    protected void placeBlocks(ServerLevel level, E entity) {
        MetropolizeBlockPos toPlace = this.targetNode.getBlockPosToPlace();
        if (toPlace == null || MovementUtils.canStandOn(entity, toPlace, level.m_8055_((BlockPos)toPlace))) {
            return;
        }
        if (!((ServerCompanionEntity)entity).suffocatesAt(entity.m_20183_())) {
            ((ServerCompanionEntity)entity).getBlockPlaceControl().setPlacementTarget(toPlace);
        }
    }

    protected void doMoveTo(ServerLevel level, E entity) {
        ((ServerCompanionEntity)entity).f_20901_ = 0.0f;
        entity.m_20282_(false);
        ((ServerCompanionEntity)entity).resetPose();
        Vec3 displacement = this.targetNode.pos.m_82546_(((ServerCompanionEntity)entity).mtzPosition());
        if (!this.targetNode.isReachedHorizontal((Level)level, ((ServerCompanionEntity)entity).mtzPosition())) {
            float speed = !entity.m_20069_() ? (float)entity.m_21133_(Attributes.f_22279_) : (float)entity.m_21133_((Attribute)ForgeMod.SWIM_SPEED.get());
            entity.m_7910_(speed);
            double theta_x = Math.atan2(displacement.f_82481_, displacement.f_82479_);
            double theta_z = theta_x - 1.5707963267948966;
            if (this.shouldRotate(entity)) {
                entity.m_146922_((float)Math.toDegrees(theta_z));
            }
            double alpha = Math.toRadians(entity.m_146908_()) - theta_z;
            if (displacement.m_165924_() > 0.2) {
                ((ServerCompanionEntity)entity).f_20902_ = (float)Math.cos(alpha);
                ((ServerCompanionEntity)entity).f_20900_ = (float)Math.sin(alpha);
            } else {
                ((ServerCompanionEntity)entity).f_20902_ = (float)(Math.cos(alpha) * displacement.m_165924_());
                ((ServerCompanionEntity)entity).f_20900_ = (float)(Math.sin(alpha) * displacement.m_165924_());
            }
        } else {
            ((ServerCompanionEntity)entity).f_20902_ = 0.0f;
            ((ServerCompanionEntity)entity).f_20900_ = 0.0f;
        }
        if (entity.m_20069_()) {
            Move move = this.targetNode.getMove();
            if (move instanceof DescendMove) {
                entity.sinkInFluid((FluidType)ForgeMod.WATER_TYPE.get());
            } else if (!level.m_6425_(entity.m_20183_()).m_76179_((BlockGetter)level, entity.m_20183_()).equals((Object)Vec3.f_82478_) || move == Moves.BUILD_UP) {
                ((ServerCompanionEntity)entity).getJumpControl().jump();
            }
        }
        if (displacement.f_82480_ > (double)entity.getStepHeight() && displacement.m_165925_() < (double)Math.max(1.0f, entity.m_20205_())) {
            ((ServerCompanionEntity)entity).getJumpControl().jump();
        }
    }

    protected void doSwim(E entity) {
        if (entity.m_20182_().m_82546_(this.path.getLastNode().pos).m_165925_() > 1.5) {
            entity.m_20124_(Pose.SWIMMING);
            ((ServerCompanionEntity)entity).f_19815_ = SWIMMING_DIMENSIONS;
            entity.m_20282_(true);
        }
        Vec3 displacement = this.targetNode.pos.m_82546_(((ServerCompanionEntity)entity).mtzPosition());
        double horizontalNorm = displacement.m_165924_();
        if (Math.abs(displacement.f_82480_) > (double)0.1f) {
            double phi = -Math.toDegrees(Math.atan2(displacement.f_82480_, horizontalNorm));
            phi = Mth.m_14008_((double)-90.0, (double)Mth.m_14175_((double)phi), (double)90.0);
            entity.m_146926_((float)MoveAlongPath.rotate(entity.m_146909_(), phi, 90.0));
            if (this.targetNode.getMovementError((Vec3)((ServerCompanionEntity)entity).mtzPosition()).f_82480_ > 0.1) {
                entity.sinkInFluid((FluidType)ForgeMod.WATER_TYPE.get());
            } else if (this.targetNode.pos.m_82546_(((ServerCompanionEntity)entity).mtzPosition()).m_165924_() < 1.0 || this.targetNode.getMovementError((Vec3)((ServerCompanionEntity)entity).mtzPosition()).f_82480_ < -0.1) {
                ((ServerCompanionEntity)entity).getJumpControl().jump();
            }
        }
        if (displacement.m_165925_() > (double)0.1f) {
            double theta = Math.toDegrees(Math.atan2(displacement.f_82481_, displacement.f_82479_)) - 90.0;
            entity.m_146922_((float)MoveAlongPath.rotate(entity.m_146908_(), theta, 60.0));
        }
        double phiRad = Math.toRadians(entity.m_146909_());
        double swimSpeed = entity.m_21133_((Attribute)ForgeMod.SWIM_SPEED.get());
        entity.m_7910_((float)swimSpeed);
        ((ServerCompanionEntity)entity).f_20902_ = (float)(Math.cos(phiRad) * swimSpeed);
        ((ServerCompanionEntity)entity).f_20901_ = (float)(-Math.sin(phiRad) * swimSpeed);
    }

    private boolean shouldRotate(E entity) {
        return !entity.m_6117_() || !entity.m_21211_().m_204117_(Tags.Items.TOOLS_SHIELDS);
    }

    protected static double rotate(double prevAngle, double nextAngle, double maxRotation) {
        double delta = Mth.m_14175_((double)(nextAngle - prevAngle));
        double result = prevAngle + (delta = Mth.m_14008_((double)(-maxRotation), (double)delta, (double)maxRotation));
        if (result < 0.0) {
            result += 360.0;
        } else if (result > 360.0) {
            result -= 360.0;
        }
        return result;
    }
}

