/*
 * Decompiled with CFR 0.152.
 */
package com.metropolize.mtz_companions.entity.behaviors.pathfinding;

import com.metropolize.mtz_companions.entity.ServerCompanionEntity;
import com.metropolize.mtz_companions.navigation.MtzWalkTarget;
import com.metropolize.mtzcharacterengine.api.core.behaviour.ExtendedBehaviour;
import com.metropolize.mtzcharacterengine.util.BrainUtils;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.TriPredicate;
import org.jetbrains.annotations.NotNull;

public class FleeFromEntity<E extends ServerCompanionEntity>
extends ExtendedBehaviour<E> {
    private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.of((Object[])new Pair[]{Pair.of((Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.REGISTERED)});
    protected BiFunction<E, Integer, LivingEntity> fleeTargetSelector = (entity, fleeThreshold) -> {
        List nearbyEntities = entity.m_9236_().m_6443_(LivingEntity.class, new AABB(entity.m_20183_()).m_82400_((double)fleeThreshold.intValue()), e -> !(e instanceof Player));
        return !nearbyEntities.isEmpty() ? nearbyEntities.stream().min(Comparator.comparingDouble(e -> e.m_20270_((Entity)entity))).orElseThrow() : null;
    };
    protected WalkTargetSelector walkTargetSelector = (entity, fleeThreshold, fleeDistance, targetToFlee) -> {
        Vec3 posToFlee = targetToFlee.m_20182_();
        BlockPos direction = BlockPos.m_274446_((Position)entity.m_20182_().m_82546_(posToFlee).m_82541_().m_82490_((double)fleeDistance));
        BlockPos targetPos = entity.m_20183_().m_121955_((Vec3i)direction);
        return new MtzWalkTarget(targetPos, 1.0f, (double)fleeDistance).withoutLineOfSight().withPredicate((TriPredicate<Entity, MtzWalkTarget, BlockPos>)((TriPredicate)(e, target, pos) -> posToFlee.m_82554_(pos.m_252807_()) >= (double)fleeDistance));
    };
    protected int fleeThreshold = 10;
    protected int fleeDistance = 20;
    protected LivingEntity fleeTarget = null;
    protected MtzWalkTarget walkTarget = null;

    public FleeFromEntity<E> withFleeTargetSelector(BiFunction<E, Integer, LivingEntity> selector) {
        this.fleeTargetSelector = selector;
        return this;
    }

    public FleeFromEntity<E> withFleeThreshold(int fleeThreshold) {
        this.fleeThreshold = fleeThreshold;
        return this;
    }

    public FleeFromEntity<E> withFleeDistance(int fleeDistance) {
        this.fleeDistance = fleeDistance;
        return this;
    }

    public FleeFromEntity<E> withWalkTargetSelector(WalkTargetSelector walkTargetSelector) {
        this.walkTargetSelector = walkTargetSelector;
        return this;
    }

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    protected boolean checkExtraStartConditions(@NotNull ServerLevel level, @NotNull E entity) {
        this.fleeTarget = this.fleeTargetSelector.apply(entity, this.fleeThreshold);
        return this.fleeTarget != null;
    }

    protected void start(E entity) {
        this.walkTarget = this.walkTargetSelector.apply((ServerCompanionEntity)entity, this.fleeThreshold, this.fleeDistance, this.fleeTarget);
        BrainUtils.setMemory(entity, (MemoryModuleType)MemoryModuleType.f_26370_, (Object)((Object)this.walkTarget));
    }

    protected void stop(E entity) {
        this.fleeTarget = null;
        this.walkTarget = null;
    }

    protected boolean shouldKeepRunning(E entity) {
        return this.fleeTargetSelector.apply(entity, this.fleeDistance) == this.fleeTarget && this.walkTarget.equals(BrainUtils.getMemory(entity, (MemoryModuleType)MemoryModuleType.f_26370_)) && !this.walkTarget.isReached((ServerCompanionEntity)entity, ((ServerCompanionEntity)entity).mtzBlockPosition());
    }

    @FunctionalInterface
    public static interface WalkTargetSelector {
        public MtzWalkTarget apply(ServerCompanionEntity var1, int var2, int var3, LivingEntity var4);
    }
}

