/*
 * Decompiled with CFR 0.152.
 */
package com.metropolize.mtz_companions.entity.behaviors.pathfinding;

import com.metropolize.mtz_companions.entity.ServerCompanionEntity;
import com.metropolize.mtz_companions.entity.behaviors.pathfinding.FleeFromEntity;
import com.metropolize.mtz_companions.entity.data.memories.MemoryModuleTypes;
import com.metropolize.mtz_companions.navigation.MtzWalkTarget;
import com.metropolize.mtzcharacterengine.MtzBrainOwner;
import com.metropolize.mtzcharacterengine.util.BrainUtils;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.TriPredicate;

public class FleeTowardsHome<E extends ServerCompanionEntity>
extends FleeFromEntity<E> {
    private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.of((Object[])new Pair[]{Pair.of((Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.REGISTERED), Pair.of((Object)MemoryModuleType.f_26367_, (Object)MemoryStatus.REGISTERED), Pair.of((Object)((MemoryModuleType)MemoryModuleTypes.KNOWN_BEDS.get()), (Object)MemoryStatus.REGISTERED)});

    @Override
    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    public FleeTowardsHome() {
        this.withWalkTargetSelector((entity, fleeThreshold, fleeDistance, targetToFlee) -> {
            Vec3 posToFlee = targetToFlee.m_20182_();
            Vec3 fleeDirection = this.getFleeDirection(entity, targetToFlee);
            return new MtzWalkTarget(BlockPos.m_274446_((Position)entity.m_20182_().m_82549_(fleeDirection.m_82490_((double)fleeDistance))), 1.0f, (double)fleeDistance).withoutLineOfSight().withPredicate((TriPredicate<Entity, MtzWalkTarget, BlockPos>)((TriPredicate)(e, target, pos) -> posToFlee.m_82554_(pos.m_252807_()) >= (double)fleeDistance));
        });
    }

    private BlockPos getPreferredPosition(ServerCompanionEntity entity) {
        List<Player> nearestPlayers = ((List)BrainUtils.memoryOrDefault((MtzBrainOwner)entity, (MemoryModuleType)MemoryModuleType.f_26367_, ArrayList::new)).stream().filter(player -> !(player instanceof ServerCompanionEntity)).toList();
        if (!nearestPlayers.isEmpty()) {
            return nearestPlayers.get(0).m_20183_();
        }
        List beds = (List)BrainUtils.memoryOrDefault((MtzBrainOwner)entity, (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.KNOWN_BEDS.get()), ArrayList::new);
        if (!beds.isEmpty()) {
            return beds.stream().min(Comparator.comparingDouble(a -> a.m_203193_((Position)entity.m_20182_()))).orElseThrow();
        }
        return null;
    }

    private Vec3 getFleeDirection(ServerCompanionEntity entity, LivingEntity targetToFlee) {
        Vec3 posToFlee = targetToFlee.m_20182_();
        Vec3 fleeDirection = entity.m_20182_().m_82546_(posToFlee).m_82541_();
        BlockPos preferredPos = this.getPreferredPosition(entity);
        if (preferredPos != null) {
            Vec3 preferredDirection = preferredPos.m_252807_().m_82546_(entity.m_20182_()).m_82541_();
            double angle = Math.acos(fleeDirection.m_82526_(preferredDirection));
            if (angle < 0.7853981633974483) {
                return preferredDirection;
            }
            double crossY = fleeDirection.m_82537_((Vec3)preferredDirection).f_82480_;
            return fleeDirection.m_82524_((float)(Math.copySign(1.0, crossY) * Math.PI / 4.0));
        }
        return fleeDirection;
    }
}

