/*
 * Decompiled with CFR 0.152.
 */
package com.metropolize.mtz_companions.entity.behaviors.pathfinding;

import com.metropolize.mtz_companions.entity.ServerCompanionEntity;
import com.metropolize.mtz_companions.entity.data.memories.MemoryModuleTypes;
import com.metropolize.mtz_companions.navigation.CompanionPathfinder;
import com.metropolize.mtz_companions.navigation.MtzWalkTarget;
import com.metropolize.mtzcharacterengine.api.core.behaviour.ExtendedBehaviour;
import com.metropolize.mtzcharacterengine.util.BrainUtils;
import com.mojang.logging.LogUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import lombok.NonNull;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public abstract class PathfindingBehavior<E extends ServerCompanionEntity>
extends ExtendedBehaviour<E> {
    private static final Logger log = LogUtils.getLogger();
    private CompanionPathfinder pathfinder = null;
    protected MtzWalkTarget pathfindingTarget = null;
    protected List<MtzWalkTarget> targets = null;
    private final HashMap<MtzWalkTarget, Long> reachableTargets = new HashMap();
    private static final int REACHABLE_VALID_FOR = 100;

    protected CompanionPathfinder getPathfinder(E entity) {
        String key = ((Object)((Object)this)).getClass().getName();
        if (((ServerCompanionEntity)entity).pathedBehaviorPathfinders.containsKey(key)) {
            return ((ServerCompanionEntity)entity).pathedBehaviorPathfinders.get(key);
        }
        CompanionPathfinder pathfinder = new CompanionPathfinder((ServerCompanionEntity)entity);
        ((ServerCompanionEntity)entity).pathedBehaviorPathfinders.put(key, pathfinder);
        return pathfinder;
    }

    protected boolean checkExtraStartConditions(@NotNull ServerLevel level, @NotNull E entity) {
        if (((ServerCompanionEntity)entity).getMtzBrain().isRunningBehavior((ExtendedBehaviour)this)) {
            return true;
        }
        if (!this.checkOtherStartingConditions(level, entity)) {
            return false;
        }
        List<MtzWalkTarget> targets = this.getPathfindingTargets(level, entity);
        if (BrainUtils.hasMemory(entity, (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.PATHFINDING_TETHER.get()))) {
            MtzWalkTarget tether = (MtzWalkTarget)((Object)BrainUtils.getMemory(entity, (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.PATHFINDING_TETHER.get())));
            targets = targets.stream().filter(t -> tether.isReached((ServerCompanionEntity)entity, t.getTargetBlockPos())).toList();
        }
        this.pathfindingTarget = this.canReachAny(entity, targets);
        if (this.pathfindingTarget != null) {
            this.targets = targets;
            this.reachableTargets.put(this.pathfindingTarget, level.m_46467_());
            return true;
        }
        return false;
    }

    protected boolean shouldKeepRunning(E entity) {
        Optional<MtzWalkTarget> reached = this.targets.stream().filter(t -> t.isReached((ServerCompanionEntity)entity, entity.mtzBlockPosition())).findFirst();
        if (reached.isPresent()) {
            this.reachableTargets.remove((Object)reached.get());
            return false;
        }
        return this.pathfindingTarget.equals(BrainUtils.getMemory(entity, (MemoryModuleType)MemoryModuleType.f_26370_)) && (((ServerCompanionEntity)entity).getPathFinder().getPath() == null || ((ServerCompanionEntity)entity).getPathFinder().didSucceed());
    }

    protected boolean m_7773_(long gameTime) {
        return false;
    }

    protected void tick(E entity) {
        long currentTime = entity.m_9236_().m_46467_();
        List<MtzWalkTarget> newTargets = this.targets.stream().filter(this.reachableTargets::containsKey).toList();
        MtzWalkTarget reachable = this.canReachAny(entity, newTargets);
        if (reachable != null) {
            this.reachableTargets.put(reachable, currentTime);
        }
    }

    protected void start(E entity) {
        BrainUtils.setMemory(entity, (MemoryModuleType)MemoryModuleType.f_26370_, (Object)((Object)this.pathfindingTarget));
        ((ServerCompanionEntity)entity).getPathFinder().setPath(this.pathfinder.getReachedTarget(), this.pathfinder.getReachedBlockPos(), this.pathfinder.getPath());
    }

    protected void stop(E entity) {
        this.pathfinder.clear();
        this.pathfindingTarget = null;
        this.targets = null;
    }

    protected MtzWalkTarget canReachAny(E entity, List<MtzWalkTarget> targets) {
        if (this.pathfinder == null) {
            this.pathfinder = this.getPathfinder(entity);
        }
        if (targets == null || targets.isEmpty()) {
            return null;
        }
        Optional<MtzWalkTarget> reachedTarget = targets.stream().filter(target -> target.isReached((ServerCompanionEntity)entity, entity.mtzBlockPosition())).findFirst();
        if (reachedTarget.isPresent()) {
            return reachedTarget.get();
        }
        long currentTime = entity.m_9236_().m_46467_();
        this.reachableTargets.keySet().removeIf(target -> currentTime - this.reachableTargets.getOrDefault(target, 0L) > 100L);
        reachedTarget = targets.stream().filter(this.reachableTargets::containsKey).findFirst();
        if (reachedTarget.isPresent()) {
            return reachedTarget.get();
        }
        if (this.pathfinder.didSucceed() && targets.stream().anyMatch(t -> t.isReached((ServerCompanionEntity)entity, this.pathfinder.getReachedBlockPos()))) {
            return targets.stream().filter(t -> t.isReached((ServerCompanionEntity)entity, this.pathfinder.getReachedBlockPos())).findFirst().orElseThrow();
        }
        if (this.pathfinder.getPath() == null && this.pathfinder.hasGoal() && this.pathfinder.isRunning()) {
            this.pathfinder.tick();
            return this.pathfinder.getReachedTarget();
        }
        this.pathfinder.setGoal(((ServerCompanionEntity)entity).mtzBlockPosition(), targets);
        this.pathfinder.tick();
        return null;
    }

    @NonNull
    protected abstract List<MtzWalkTarget> getPathfindingTargets(ServerLevel var1, E var2);

    protected boolean checkOtherStartingConditions(ServerLevel level, E entity) {
        return true;
    }
}

