/*
 * Decompiled with CFR 0.152.
 */
package com.metropolize.mtz_companions.entity.behaviors.pathfinding;

import com.metropolize.mtz_companions.entity.ServerCompanionEntity;
import com.metropolize.mtz_companions.entity.behaviors.pathfinding.PathfindingBehavior;
import com.metropolize.mtz_companions.entity.data.memories.MemoryModuleTypes;
import com.metropolize.mtz_companions.entity.sensors.NearestBedSensor;
import com.metropolize.mtz_companions.navigation.MtzWalkTarget;
import com.metropolize.mtzcharacterengine.util.BrainUtils;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.BiPredicate;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.NonNull;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraftforge.common.ForgeMod;

@ParametersAreNonnullByDefault
public class SetBedWalkTarget<E extends ServerCompanionEntity>
extends PathfindingBehavior<E> {
    private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.of((Object[])new Pair[]{Pair.of((Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.REGISTERED), Pair.of((Object)MemoryModuleType.f_26371_, (Object)MemoryStatus.REGISTERED), Pair.of((Object)((MemoryModuleType)MemoryModuleTypes.SLEEP_COOLING_DOWN.get()), (Object)MemoryStatus.VALUE_ABSENT), Pair.of(MemoryModuleTypes.NEAREST_AVAILABLE_BEDS.get(), (Object)MemoryStatus.VALUE_PRESENT), Pair.of(MemoryModuleTypes.BED_TARGET.get(), (Object)MemoryStatus.REGISTERED)});
    protected BiPredicate<ServerCompanionEntity, BlockPos> predicate = NearestBedSensor.availableBedPredicate;

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    @Override
    @NonNull
    protected List<MtzWalkTarget> getPathfindingTargets(ServerLevel level, E entity) {
        List beds = (List)BrainUtils.getMemory(entity, MemoryModuleTypes.NEAREST_AVAILABLE_BEDS.get());
        return beds.stream().filter(bedPos -> this.predicate.test((ServerCompanionEntity)entity, (BlockPos)bedPos)).map(bedPos -> new MtzWalkTarget((BlockPos)bedPos, 1.0f, (double)((int)entity.m_21133_((Attribute)ForgeMod.BLOCK_REACH.get()) - 1)).canInteract()).toList();
    }

    @Override
    protected boolean checkOtherStartingConditions(ServerLevel level, E entity) {
        return level.m_46462_();
    }

    @Override
    protected void start(E entity) {
        super.start(entity);
        BrainUtils.setMemory(entity, (MemoryModuleType)MemoryModuleType.f_26371_, (Object)this.pathfindingTarget.m_26420_());
        BrainUtils.setMemory(entity, MemoryModuleTypes.BED_TARGET.get(), (Object)this.pathfindingTarget.m_26420_().m_6675_());
    }
}

