/*
 * Decompiled with CFR 0.152.
 */
package com.metropolize.mtz_companions.entity.behaviors.pathfinding;

import com.metropolize.mtz_companions.capabilities.IProtectedBlocksCapability;
import com.metropolize.mtz_companions.core.MetropolizeBlockPos;
import com.metropolize.mtz_companions.entity.ServerCompanionEntity;
import com.metropolize.mtz_companions.entity.behaviors.pathfinding.PathfindingBehavior;
import com.metropolize.mtz_companions.entity.data.memories.MemoryModuleTypes;
import com.metropolize.mtz_companions.entity.metropolize.MtzItemConstants;
import com.metropolize.mtz_companions.navigation.MtzWalkTarget;
import com.metropolize.mtz_companions.navigation.utils.MovementUtils;
import com.metropolize.mtz_companions.utils.LootTableUtils;
import com.metropolize.mtzcharacterengine.MtzBrainOwner;
import com.metropolize.mtzcharacterengine.util.BrainUtils;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Function;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.NonNull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.util.TriPredicate;
import net.minecraftforge.registries.RegistryObject;

@ParametersAreNonnullByDefault
public class SetBlockTarget<E extends ServerCompanionEntity>
extends PathfindingBehavior<E> {
    private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.of((Object[])new Pair[]{Pair.of((Object)((MemoryModuleType)MemoryModuleTypes.ASYNC_NEAREST_WANTED_BLOCKS.get()), (Object)MemoryStatus.REGISTERED), Pair.of((Object)((MemoryModuleType)MemoryModuleTypes.BLOCK_TARGET.get()), (Object)MemoryStatus.REGISTERED), Pair.of((Object)MemoryModuleType.f_26371_, (Object)MemoryStatus.REGISTERED), Pair.of((Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.REGISTERED)});
    private static final int MAX_GROUP_SIZE = 8;
    private static final int BLOCK_GROUP_TIMEOUT = 20;
    protected final BiPredicate<Entity, BlockPos> targetablePredicate = (entity, blockPos) -> {
        ServerLevel level = (ServerLevel)entity.m_9236_();
        BlockState state = level.m_8055_(blockPos);
        if (IProtectedBlocksCapability.get((Level)level, blockPos).isProtectedBlock((BlockPos)blockPos, state)) {
            return false;
        }
        if (level.m_8802_(blockPos)) {
            if (MtzItemConstants.VILLAGE_PROTECTED_BLOCKS.stream().anyMatch(arg_0 -> ((BlockState)state).m_204336_(arg_0))) {
                return false;
            }
        }
        return true;
    };
    protected final TriPredicate<Entity, MtzWalkTarget, BlockPos> reachabilityPredicate = (entity, target, blockPos) -> {
        boolean isNotOnTop;
        boolean inReach;
        Level level = entity.m_9236_();
        boolean bl = inReach = Math.sqrt(target.getTargetBlockPos().m_203193_((Position)blockPos.m_252807_().m_82520_(0.0, (double)entity.m_20192_(), 0.0))) <= ((ServerCompanionEntity)entity).m_21133_((Attribute)ForgeMod.BLOCK_REACH.get()) + 0.5;
        if (!inReach) {
            return false;
        }
        BlockState state1 = level.m_8055_(blockPos);
        BlockState state2 = level.m_8055_(blockPos.m_7494_());
        boolean onLand = state1.m_60819_().m_76178_() && state2.m_60819_().m_76178_();
        boolean bl2 = isNotOnTop = !blockPos.equals((Object)target.getTargetBlockPos().above());
        if (this.placedBlocksToCleanUp.contains(blockPos) && MovementUtils.canStandOn(entity, blockPos.m_7495_(), level.m_8055_(blockPos.m_7495_()))) {
            isNotOnTop = true;
        }
        return onLand && isNotOnTop;
    };
    protected Function<ServerCompanionEntity, List<BlockPos>> getCandidateBlocks = entity -> {
        Level level = entity.m_9236_();
        ArrayList<BlockPos> candidates = new ArrayList<BlockPos>();
        Pair cleanup = (Pair)BrainUtils.getMemory((MtzBrainOwner)entity, (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.CRAFTING_BLOCK_CLEANUP_TARGET.get()));
        if (!BrainUtils.hasMemory((MtzBrainOwner)entity, (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.CRAFTING_BLOCK_CLEANUP_DELAY.get())) && cleanup != null) {
            if (level.m_8055_((BlockPos)cleanup.getFirst()).m_60713_(((BlockState)cleanup.getSecond()).m_60734_())) {
                candidates.add((BlockPos)cleanup.getFirst());
            } else {
                BrainUtils.clearMemory((MtzBrainOwner)entity, (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.CRAFTING_BLOCK_CLEANUP_TARGET.get()));
            }
        }
        RegistryObject<MemoryModuleType<Map<BlockPos, Block>>> registryObject = MemoryModuleTypes.ASYNC_NEAREST_WANTED_BLOCKS;
        synchronized (registryObject) {
            Map wantedBlocks = (Map)BrainUtils.getMemory((MtzBrainOwner)entity, (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.ASYNC_NEAREST_WANTED_BLOCKS.get()));
            if (wantedBlocks != null) {
                candidates.addAll(wantedBlocks.entrySet().stream().filter(entry -> level.m_8055_((BlockPos)entry.getKey()).m_60713_((Block)entry.getValue())).map(Map.Entry::getKey).toList());
            }
        }
        return candidates;
    };
    protected Block targetBlock = null;
    protected final List<BlockPos> blocksInSameGroup = new ArrayList<BlockPos>();
    protected final List<BlockPos> placedBlocksToCleanUp = new ArrayList<BlockPos>();
    protected int blockGroupTimeout = 20;
    protected int cleanupTimeout = 20;
    private boolean isCleaningUp = false;

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    public SetBlockTarget<E> withCandidateBlocks(Function<ServerCompanionEntity, List<BlockPos>> candidateProvider) {
        this.getCandidateBlocks = candidateProvider;
        return this;
    }

    @Override
    @NonNull
    protected List<MtzWalkTarget> getPathfindingTargets(ServerLevel level, E entity) {
        ArrayList<Object> targets;
        if (!this.blocksInSameGroup.isEmpty() && this.blockGroupTimeout != 0 && this.blocksInSameGroup.stream().anyMatch(blockPos -> LootTableUtils.blockDropsWantedItem(entity, blockPos, level.m_8055_(blockPos)))) {
            targets = new ArrayList<Vec3i>(this.blocksInSameGroup.stream().filter(blockPos -> level.m_8055_(blockPos).m_60713_(this.targetBlock)).sorted(Comparator.comparingInt(Vec3i::m_123342_).reversed()).toList());
            this.blocksInSameGroup.clear();
            this.blocksInSameGroup.addAll(targets);
            --this.blockGroupTimeout;
        } else if (!this.placedBlocksToCleanUp.isEmpty() && this.cleanupTimeout != 0) {
            this.blocksInSameGroup.clear();
            targets = new ArrayList<Vec3i>(this.placedBlocksToCleanUp.stream().filter(blockPos -> !level.m_46859_(blockPos)).sorted(Comparator.comparingInt(Vec3i::m_123342_).reversed()).toList());
            --this.cleanupTimeout;
            this.isCleaningUp = true;
        } else {
            this.isCleaningUp = false;
            this.blocksInSameGroup.clear();
            this.placedBlocksToCleanUp.clear();
            this.blockGroupTimeout = 20;
            this.cleanupTimeout = 20;
            List<BlockPos> blocks = this.getCandidateBlocks.apply((ServerCompanionEntity)entity);
            targets = blocks == null ? new ArrayList() : new ArrayList<BlockPos>(blocks.stream().filter(blockPos -> this.targetablePredicate.test((Entity)entity, (BlockPos)blockPos)).limit(16L).toList());
        }
        return targets.stream().map(blockPos -> new MtzWalkTarget((BlockPos)blockPos, 1.0f, (double)((int)entity.m_21133_((Attribute)ForgeMod.BLOCK_REACH.get()))).withPredicate(this.reachabilityPredicate).canInteract()).toList();
    }

    @Override
    protected void start(E entity) {
        this.blockGroupTimeout = 20;
        this.cleanupTimeout = 20;
        if (((ServerCompanionEntity)entity).getBlockBreakControl().wasBreaking()) {
            return;
        }
        if (!this.isCleaningUp) {
            MetropolizeBlockPos target;
            ServerLevel level = (ServerLevel)entity.m_9236_();
            if (this.targetBlock != level.m_8055_((BlockPos)(target = this.pathfindingTarget.getTargetBlockPos())).m_60734_()) {
                this.targetBlock = level.m_8055_((BlockPos)target).m_60734_();
                this.blocksInSameGroup.clear();
            }
            ArrayDeque<BlockPos> blocksToCheck = new ArrayDeque<BlockPos>();
            blocksToCheck.add(target);
            while (!blocksToCheck.isEmpty() && this.blocksInSameGroup.size() < 8) {
                BlockPos checkedBlock = (BlockPos)blocksToCheck.pop();
                List<BlockPos> matches = BlockPos.m_121990_((BlockPos)checkedBlock.m_121955_(new Vec3i(1, 3, 1)), (BlockPos)checkedBlock.m_121955_(new Vec3i(-1, -1, -1))).map(BlockPos::m_7949_).filter(blockPos -> !blockPos.equals((Object)checkedBlock) && !this.blocksInSameGroup.contains(blockPos) && level.m_8055_(blockPos).m_60713_(this.targetBlock)).toList();
                this.blocksInSameGroup.addAll(matches);
                blocksToCheck.addAll(matches);
            }
        }
        if (this.targetBlock.m_49966_().m_204336_(BlockTags.f_13106_)) {
            ((ServerCompanionEntity)entity).getBlockPlaceControl().startTrackingPlaced();
        }
        BrainUtils.setMemory(entity, (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.BLOCK_TARGET.get()), (Object)this.pathfindingTarget.m_26420_().m_6675_());
        BrainUtils.setMemory(entity, (MemoryModuleType)MemoryModuleType.f_26371_, (Object)this.pathfindingTarget.m_26420_());
        BrainUtils.setMemory(entity, (MemoryModuleType)MemoryModuleType.f_26370_, (Object)((Object)this.pathfindingTarget));
    }

    @Override
    protected boolean shouldKeepRunning(E entity) {
        if (!super.shouldKeepRunning(entity)) {
            return false;
        }
        return entity.m_9236_().m_8055_((BlockPos)this.pathfindingTarget.getTargetBlockPos()).m_60713_(this.targetBlock);
    }

    @Override
    protected void stop(E entity) {
        super.stop(entity);
        BrainUtils.clearMemory(entity, (MemoryModuleType)MemoryModuleType.f_26370_);
        ArrayList<BlockPos> placedBlocks = new ArrayList<BlockPos>(((ServerCompanionEntity)entity).getBlockPlaceControl().getPlacedBlocks());
        Collections.reverse(placedBlocks);
        this.placedBlocksToCleanUp.addAll(placedBlocks);
        ((ServerCompanionEntity)entity).getBlockPlaceControl().stopTrackingPlaced();
    }
}

