/*
 * Decompiled with CFR 0.152.
 */
package com.metropolize.mtz_companions.entity.behaviors.pathfinding;

import com.metropolize.mtz_companions.entity.ServerCompanionEntity;
import com.metropolize.mtz_companions.entity.behaviors.pathfinding.PathfindingBehavior;
import com.metropolize.mtz_companions.entity.data.memories.MemoryModuleTypes;
import com.metropolize.mtz_companions.navigation.MtzWalkTarget;
import com.metropolize.mtz_companions.utils.ContainerUtils;
import com.metropolize.mtzcharacterengine.util.BrainUtils;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.NonNull;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraftforge.common.ForgeMod;

public class SetChestTarget<E extends ServerCompanionEntity>
extends PathfindingBehavior<E> {
    private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.of((Object[])new Pair[]{Pair.of((Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.REGISTERED), Pair.of((Object)MemoryModuleType.f_26371_, (Object)MemoryStatus.REGISTERED), Pair.of(MemoryModuleTypes.INTERACTION_TARGET.get(), (Object)MemoryStatus.REGISTERED), Pair.of((Object)((MemoryModuleType)MemoryModuleTypes.ASYNC_NEAREST_CHESTS.get()), (Object)MemoryStatus.VALUE_PRESENT)});
    private final Set<BlockPos> chestBlocksWithRoom = new HashSet<BlockPos>();

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    @Override
    protected boolean checkOtherStartingConditions(ServerLevel level, E entity) {
        List chestPosList = (List)BrainUtils.getMemory(entity, (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.ASYNC_NEAREST_CHESTS.get()));
        if (chestPosList == null || chestPosList.isEmpty()) {
            return false;
        }
        for (BlockPos chestPos : chestPosList) {
            Set<ItemStack> itemsToStore;
            BlockEntity blockEntity = level.m_7702_(chestPos);
            if (!(blockEntity instanceof ChestBlockEntity)) continue;
            ChestBlockEntity chestBlockEntity = (ChestBlockEntity)blockEntity;
            if (ChestBlock.m_51508_((LevelAccessor)level, (BlockPos)chestPos) || (itemsToStore = ContainerUtils.getItemsToStoreInChest(entity, (ChestBlockEntity)blockEntity)).isEmpty() || !ContainerUtils.canFitInContainer((Container)chestBlockEntity, itemsToStore)) continue;
            this.chestBlocksWithRoom.add(chestPos);
        }
        return !this.chestBlocksWithRoom.isEmpty();
    }

    @Override
    protected void start(E entity) {
        super.start(entity);
        BrainUtils.setMemory(entity, (MemoryModuleType)MemoryModuleType.f_26371_, (Object)this.pathfindingTarget.m_26420_());
        BrainUtils.setMemory(entity, MemoryModuleTypes.INTERACTION_TARGET.get(), (Object)this.pathfindingTarget.m_26420_().m_6675_());
    }

    @Override
    protected void stop(E entity) {
        this.chestBlocksWithRoom.clear();
    }

    @Override
    @NonNull
    protected List<MtzWalkTarget> getPathfindingTargets(ServerLevel level, E entity) {
        return this.chestBlocksWithRoom.stream().map(chestPos -> new MtzWalkTarget((BlockPos)chestPos, 1.0f, (double)((int)entity.m_21133_((Attribute)ForgeMod.BLOCK_REACH.get()) - 1)).canInteract()).toList();
    }
}

