/*
 * Decompiled with CFR 0.152.
 */
package com.metropolize.mtz_companions.entity.behaviors.pathfinding;

import com.metropolize.mtz_companions.entity.ServerCompanionEntity;
import com.metropolize.mtz_companions.entity.behaviors.pathfinding.PathfindingBehavior;
import com.metropolize.mtz_companions.entity.data.memories.MemoryModuleTypes;
import com.metropolize.mtz_companions.navigation.MtzWalkTarget;
import com.metropolize.mtz_companions.navigation.utils.MovementUtils;
import com.metropolize.mtzcharacterengine.MtzBrainOwner;
import com.metropolize.mtzcharacterengine.util.BrainUtils;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import lombok.NonNull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.common.util.TriPredicate;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class SetExplorationWalkTarget<E extends ServerCompanionEntity>
extends PathfindingBehavior<E> {
    private static final Logger log = LogUtils.getLogger();
    private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.of((Object[])new Pair[]{Pair.of((Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.REGISTERED), Pair.of((Object)((MemoryModuleType)MemoryModuleTypes.WANTS_TO_EXPLORE.get()), (Object)MemoryStatus.REGISTERED), Pair.of((Object)((MemoryModuleType)MemoryModuleTypes.WANTS_TO_EXPLORE_CAVE.get()), (Object)MemoryStatus.REGISTERED), Pair.of((Object)((MemoryModuleType)MemoryModuleTypes.PATHFINDING_TETHER.get()), (Object)MemoryStatus.REGISTERED)});
    private static final TriPredicate<Entity, MtzWalkTarget, BlockPos> reachabilityPredicate = (e, target, blockPos) -> SectionPos.m_123199_((BlockPos)blockPos).m_123251_().equals((Object)SectionPos.m_123199_((BlockPos)target.getTargetBlockPos()).m_123251_()) && MovementUtils.canStandOn(e, blockPos.m_7495_(), e.m_9236_().m_8055_(blockPos.m_7495_())) && Math.abs(e.m_9236_().m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, blockPos).m_123342_() - blockPos.m_123342_()) < 5;
    private static final double MAX_PATHFINDING_COST = 200.0;
    private static final int MAX_DISTANCE_FROM_TETHER = 8;
    private List<MtzWalkTarget> surfaceTargets = null;
    private ChunkPos chunkTarget = null;
    private boolean canExploreCave = false;

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    @Override
    @NonNull
    protected List<MtzWalkTarget> getPathfindingTargets(ServerLevel level, E entity) {
        this.surfaceTargets = this.getSurfacePathfindingTargets(entity, ((ServerCompanionEntity)entity).getVisitedChunks());
        ArrayList<MtzWalkTarget> targets = new ArrayList<MtzWalkTarget>(this.surfaceTargets);
        boolean bl = this.canExploreCave = (Boolean)BrainUtils.memoryOrDefault(entity, (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.WANTS_TO_EXPLORE_CAVE.get()), () -> false) != false && ((ServerCompanionEntity)entity).getInventory().m_216874_(itemStack -> itemStack.m_204117_(ItemTags.f_271360_));
        if (this.canExploreCave) {
            targets.addAll(this.getCavePathfindingTargets(entity));
        }
        return targets;
    }

    @Override
    protected boolean checkExtraStartConditions(@NotNull ServerLevel level, @NotNull E entity) {
        if (!((ServerCompanionEntity)entity).wantsToExplore()) {
            return false;
        }
        boolean foundPath = super.checkExtraStartConditions(level, entity);
        if (foundPath) {
            return true;
        }
        return !this.surfaceTargets.isEmpty();
    }

    protected List<MtzWalkTarget> getSurfacePathfindingTargets(E entity, Set<ChunkPos> visited) {
        Level level = entity.m_9236_();
        HashSet<ChunkPos> tested = new HashSet<ChunkPos>();
        Stack<ChunkPos> toVisit = new Stack<ChunkPos>();
        toVisit.push(entity.m_146902_());
        ArrayList<MtzWalkTarget> result = new ArrayList<MtzWalkTarget>(4);
        while (!toVisit.empty() && result.size() < 4) {
            ChunkPos chunkPos = (ChunkPos)toVisit.pop();
            tested.add(chunkPos);
            if (!visited.contains(chunkPos)) {
                this.chunkTarget = chunkPos;
                result.add(new MtzWalkTarget(this.getChunkCenter(level, this.chunkTarget), 1.0f, Double.POSITIVE_INFINITY).withPredicate(reachabilityPredicate));
            }
            List<ChunkPos> adjacentChunks = Arrays.asList(new ChunkPos(chunkPos.f_45578_ + 1, chunkPos.f_45579_), new ChunkPos(chunkPos.f_45578_ - 1, chunkPos.f_45579_), new ChunkPos(chunkPos.f_45578_, chunkPos.f_45579_ + 1), new ChunkPos(chunkPos.f_45578_, chunkPos.f_45579_ - 1));
            toVisit.addAll(adjacentChunks.stream().filter(cp -> !tested.contains(cp)).filter(cp -> this.chunkPredicate(entity, (ChunkPos)cp)).toList());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<MtzWalkTarget> getCavePathfindingTargets(E entity) {
        List walkableCaveAir;
        RegistryObject<MemoryModuleType<List<BlockPos>>> registryObject = MemoryModuleTypes.ASYNC_NEAREST_CAVES;
        synchronized (registryObject) {
            walkableCaveAir = (List)BrainUtils.getMemory(entity, (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.ASYNC_NEAREST_CAVES.get()));
        }
        if (walkableCaveAir == null || walkableCaveAir.isEmpty()) {
            return List.of();
        }
        if (((ServerCompanionEntity)entity).getExplorationData().getNearbyCave() == null) {
            return walkableCaveAir.stream().map(blockPos -> new MtzWalkTarget((BlockPos)blockPos, 1.0f, 0.0).withMaxCost(200.0)).limit(20L).toList();
        }
        return walkableCaveAir.stream().map(blockPos -> new MtzWalkTarget((BlockPos)blockPos, 1.0f, 0.0).withMaxCost(200.0)).limit(20L).toList();
    }

    @Override
    protected void start(E entity) {
        if (this.pathfindingTarget != null) {
            super.start(entity);
            BrainUtils.setMemory(entity, (MemoryModuleType)MemoryModuleType.f_26371_, (Object)this.pathfindingTarget.m_26420_());
        } else {
            BrainUtils.setMemory(entity, (MemoryModuleType)MemoryModuleType.f_26370_, (Object)((Object)this.surfaceTargets.stream().min(Comparator.comparingDouble(a -> a.getTargetBlockPos().m_203193_((Position)entity.m_20182_()))).orElseThrow()));
        }
        BrainUtils.setMemory(entity, (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.LAST_EXPLORE_TIME.get()), (Object)entity.m_9236_().m_46467_());
    }

    @Override
    protected boolean shouldKeepRunning(E entity) {
        if (!((ServerCompanionEntity)entity).wantsToExplore()) {
            return false;
        }
        if (this.pathfindingTarget != null) {
            return super.shouldKeepRunning(entity);
        }
        return false;
    }

    @Override
    protected void stop(E entity) {
        if (this.pathfindingTarget != null) {
            BrainUtils.withMemory(entity, (MemoryModuleType)MemoryModuleType.f_26370_, memory -> {
                BrainUtils.clearMemory((MtzBrainOwner)entity, (MemoryModuleType)MemoryModuleType.f_26370_);
                BrainUtils.clearMemory((MtzBrainOwner)entity, (MemoryModuleType)MemoryModuleType.f_26371_);
            });
        }
        BrainUtils.setMemory(entity, (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.LAST_EXPLORE_TIME.get()), (Object)entity.m_9236_().m_46467_());
        this.canExploreCave = false;
        this.chunkTarget = null;
    }

    private boolean chunkPredicate(E entity, ChunkPos chunkPos) {
        Level level = entity.m_9236_();
        BlockPos centerBlock = this.getChunkCenter(level, chunkPos);
        MtzWalkTarget tether = (MtzWalkTarget)((Object)BrainUtils.getMemory(entity, (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.PATHFINDING_TETHER.get())));
        if (tether != null && tether.getTargetBlockPos().distanceTo(this.getChunkCenter(entity.m_9236_(), chunkPos)) > 8.0) {
            return false;
        }
        return !level.m_204166_(centerBlock).m_203656_(BiomeTags.f_207603_) && level.m_8055_(centerBlock.m_7495_()).m_60819_().m_76178_();
    }

    private BlockPos getChunkCenter(Level level, ChunkPos chunkPos) {
        BlockPos centerBlock = chunkPos.m_151394_(0);
        return level.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, centerBlock);
    }
}

