/*
 * Decompiled with CFR 0.152.
 */
package com.metropolize.mtz_companions.entity.behaviors.pathfinding;

import com.metropolize.mtz_companions.core.MetropolizeBlockPos;
import com.metropolize.mtz_companions.entity.ServerCompanionEntity;
import com.metropolize.mtz_companions.entity.behaviors.pathfinding.PathfindingBehavior;
import com.metropolize.mtz_companions.entity.data.memories.MemoryModuleTypes;
import com.metropolize.mtz_companions.navigation.MtzWalkTarget;
import com.metropolize.mtz_companions.utils.ContainerUtils;
import com.metropolize.mtz_companions.utils.RecipeUtils;
import com.metropolize.mtzcharacterengine.util.BrainUtils;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.NonNull;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlastFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.FurnaceBlockEntity;
import net.minecraft.world.level.block.entity.SmokerBlockEntity;
import net.minecraftforge.common.ForgeMod;

public class SetFurnaceTarget<E extends ServerCompanionEntity>
extends PathfindingBehavior<E> {
    private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.of((Object[])new Pair[]{Pair.of((Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.REGISTERED), Pair.of((Object)MemoryModuleType.f_26371_, (Object)MemoryStatus.REGISTERED), Pair.of(MemoryModuleTypes.INTERACTION_TARGET.get(), (Object)MemoryStatus.REGISTERED), Pair.of((Object)((MemoryModuleType)MemoryModuleTypes.ASYNC_NEAREST_FURNACES.get()), (Object)MemoryStatus.VALUE_PRESENT)});
    protected static final int SLOT_INPUT = 0;
    protected static final int SLOT_FUEL = 1;
    protected static final int SLOT_RESULT = 2;
    protected static final int COOLDOWN_TICKS = 1200;
    private Map<BlockPos, Long> furnaceCooldowns = new HashMap<BlockPos, Long>();
    private final HashMap<MetropolizeBlockPos, ItemStack[]> furnacesToVisit = new HashMap();

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    @Override
    protected boolean checkOtherStartingConditions(ServerLevel level, E entity) {
        Set<Item> wantedItems = ((ServerCompanionEntity)entity).getWantedItems();
        List furnaces = (List)BrainUtils.getMemory(entity, (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.ASYNC_NEAREST_FURNACES.get()));
        if (furnaces.isEmpty()) {
            return false;
        }
        this.furnaceCooldowns = this.furnaceCooldowns.entrySet().stream().filter(e -> furnaces.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        for (BlockPos furnacePos : furnaces) {
            ItemStack input;
            ItemStack fuel;
            RecipeType recipeType;
            if (this.furnaceCooldowns.containsKey(furnacePos) && level.m_46467_() < this.furnaceCooldowns.get(furnacePos)) continue;
            BlockEntity blockEntity = level.m_7702_(furnacePos);
            if (blockEntity instanceof FurnaceBlockEntity) {
                recipeType = RecipeType.f_44108_;
            } else if (blockEntity instanceof SmokerBlockEntity) {
                recipeType = RecipeType.f_44110_;
            } else if (blockEntity instanceof BlastFurnaceBlockEntity) {
                recipeType = RecipeType.f_44109_;
            } else {
                return false;
            }
            AbstractFurnaceBlockEntity furnaceBlockEntity = (AbstractFurnaceBlockEntity)blockEntity;
            ItemStack[] itemsToStore = new ItemStack[2];
            ItemStack fuelSlot = furnaceBlockEntity.m_8020_(1);
            if (fuelSlot.m_41619_()) {
                ItemStack heldCoal = ((ServerCompanionEntity)entity).getInventory().findFirstItemSlot(Items.f_42413_);
                ItemStack heldCharcoal = ((ServerCompanionEntity)entity).getInventory().findFirstItemSlot(Items.f_42414_);
                if (heldCoal != null) {
                    itemsToStore[1] = heldCoal;
                } else if (heldCharcoal != null) {
                    itemsToStore[1] = heldCharcoal;
                }
            } else if (fuelSlot.m_41753_() && fuelSlot.m_41613_() < fuelSlot.m_41741_() && (fuel = ((ServerCompanionEntity)entity).getInventory().findFirstItemSlot(fuelSlot)) != null) {
                itemsToStore[1] = fuel;
            }
            ItemStack inputSlot = furnaceBlockEntity.m_8020_(0);
            ItemStack outputSlot = furnaceBlockEntity.m_8020_(2);
            if (inputSlot.m_41619_()) {
                if (outputSlot.m_41619_() || ((ServerCompanionEntity)entity).getInventory().canFitItemStack(outputSlot)) {
                    for (Item item : wantedItems) {
                        Pair<Recipe<?>, IntList> recipePair = RecipeUtils.getUsableRecipe(recipeType, item, entity);
                        if (recipePair == null) continue;
                        Ingredient ingredient = (Ingredient)((Recipe)recipePair.getFirst()).m_7527_().get(0);
                        itemsToStore[0] = ((ServerCompanionEntity)entity).getInventory().findFirstItemSlot((Predicate<ItemStack>)ingredient);
                        break;
                    }
                } else {
                    Pair<Recipe<?>, IntList> recipes = RecipeUtils.getUsableRecipe(recipeType, outputSlot.m_41720_(), entity);
                    if (recipes != null) {
                        Ingredient inputIngredient = (Ingredient)((Recipe)recipes.getFirst()).m_7527_().get(0);
                        itemsToStore[0] = ((ServerCompanionEntity)entity).getInventory().findFirstItemSlot((Predicate<ItemStack>)inputIngredient);
                    }
                }
            } else if (inputSlot.m_41613_() < inputSlot.m_41741_() && (input = ((ServerCompanionEntity)entity).getInventory().findFirstItemSlot(inputSlot)) != null) {
                itemsToStore[0] = input;
            }
            if (itemsToStore[0] == null && itemsToStore[1] == null) continue;
            this.furnacesToVisit.put(new MetropolizeBlockPos(furnacePos), itemsToStore);
        }
        return !this.furnacesToVisit.isEmpty();
    }

    @Override
    @NonNull
    protected List<MtzWalkTarget> getPathfindingTargets(ServerLevel level, E entity) {
        return this.furnacesToVisit.keySet().stream().map(blockPos -> new MtzWalkTarget((BlockPos)blockPos, 1.0f, (double)((int)entity.m_21133_((Attribute)ForgeMod.BLOCK_REACH.get()) - 1)).canInteract()).toList();
    }

    @Override
    protected void start(E entity) {
        super.start(entity);
        BrainUtils.setMemory(entity, (MemoryModuleType)MemoryModuleType.f_26371_, (Object)this.pathfindingTarget.m_26420_());
        BrainUtils.setMemory(entity, MemoryModuleTypes.INTERACTION_TARGET.get(), (Object)this.pathfindingTarget.m_26420_().m_6675_());
    }

    @Override
    protected void stop(E entity) {
        BlockEntity blockEntity;
        if (this.pathfindingTarget.isReached((ServerCompanionEntity)entity, ((ServerCompanionEntity)entity).mtzBlockPosition()) && (blockEntity = entity.m_9236_().m_7702_((BlockPos)this.pathfindingTarget.getTargetBlockPos())) != null && !blockEntity.m_58901_() && blockEntity instanceof AbstractFurnaceBlockEntity) {
            AbstractFurnaceBlockEntity furnaceBlockEntity = (AbstractFurnaceBlockEntity)blockEntity;
            this.useFurnace(entity, furnaceBlockEntity);
            blockEntity.m_6596_();
        }
        BrainUtils.setMemory(entity, (MemoryModuleType)MemoryModuleType.f_26371_, (Object)this.pathfindingTarget.m_26420_());
        BrainUtils.setMemory(entity, (MemoryModuleType)MemoryModuleType.f_26370_, (Object)((Object)this.pathfindingTarget));
        BrainUtils.setMemory(entity, MemoryModuleTypes.INTERACTION_TARGET.get(), (Object)this.pathfindingTarget.m_26420_().m_6675_());
        this.furnacesToVisit.clear();
        super.stop(entity);
    }

    private void useFurnace(E entity, AbstractFurnaceBlockEntity furnaceBlockEntity) {
        MetropolizeBlockPos furnacePos = this.pathfindingTarget.getTargetBlockPos();
        ItemStack[] toStore = this.furnacesToVisit.get((Object)furnacePos);
        assert (toStore != null);
        this.tryPlacingItem(furnaceBlockEntity, toStore, 0);
        this.tryPlacingItem(furnaceBlockEntity, toStore, 1);
        if (!furnaceBlockEntity.m_8020_(2).m_41619_() && ((ServerCompanionEntity)entity).getInventory().canFitItemStack(furnaceBlockEntity.m_8020_(2))) {
            ItemStack itemStack = furnaceBlockEntity.m_8016_(2);
            ((ServerCompanionEntity)entity).getInventory().addItem(itemStack);
        }
        entity.m_6674_(InteractionHand.MAIN_HAND);
        this.furnaceCooldowns.put(furnacePos, entity.m_9236_().m_46467_() + 1200L);
    }

    private void tryPlacingItem(AbstractFurnaceBlockEntity furnaceBlockEntity, ItemStack[] toStore, int slot) {
        ItemStack itemStack = toStore[slot];
        if (itemStack != null && furnaceBlockEntity.m_7013_(slot, itemStack)) {
            ItemStack existingItem = furnaceBlockEntity.m_8020_(slot);
            if (existingItem.m_41619_()) {
                ItemStack fuelCopy = itemStack.m_278832_();
                furnaceBlockEntity.m_6836_(slot, fuelCopy);
            } else if (ContainerUtils.canMergeItems(existingItem, itemStack)) {
                int canStore = existingItem.m_41741_() - existingItem.m_41613_();
                int amountToStore = Math.min(itemStack.m_41613_(), canStore);
                itemStack.m_41774_(amountToStore);
                furnaceBlockEntity.m_6836_(slot, new ItemStack((ItemLike)existingItem.m_41720_(), existingItem.m_41613_() + amountToStore));
            }
        }
    }
}

