/*
 * Decompiled with CFR 0.152.
 */
package com.metropolize.mtz_companions.entity.behaviors.pathfinding;

import com.metropolize.mtz_companions.entity.ServerCompanionEntity;
import com.metropolize.mtz_companions.entity.behaviors.pathfinding.PathfindingBehavior;
import com.metropolize.mtz_companions.entity.data.memories.MemoryModuleTypes;
import com.metropolize.mtz_companions.navigation.MtzWalkTarget;
import com.metropolize.mtzcharacterengine.registry.SBLMemoryTypes;
import com.metropolize.mtzcharacterengine.util.BrainUtils;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.NonNull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.util.TriPredicate;
import net.minecraftforge.registries.RegistryObject;

@ParametersAreNonnullByDefault
public class SetItemWalkTarget<E extends ServerCompanionEntity>
extends PathfindingBehavior<E> {
    private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.of((Object[])new Pair[]{Pair.of((Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.REGISTERED), Pair.of((Object)((MemoryModuleType)SBLMemoryTypes.NEARBY_ITEMS.get()), (Object)MemoryStatus.VALUE_PRESENT), Pair.of((Object)((MemoryModuleType)MemoryModuleTypes.ASYNC_NEAREST_WANTED_BLOCKS.get()), (Object)MemoryStatus.REGISTERED), Pair.of((Object)MemoryModuleType.f_26371_, (Object)MemoryStatus.REGISTERED)});
    private static final Set<Item> IGNORED_ITEMS = Set.of(Items.f_151056_, Items.f_42521_);
    protected BiPredicate<E, ItemEntity> predicate = (entity, item) -> (item.m_20096_() || item.m_20069_()) && !item.m_213877_() && !this.isItemOnTreeLeaf((ItemEntity)item) && !IGNORED_ITEMS.contains(item.m_32055_().m_41720_());
    protected TriPredicate<Entity, MtzWalkTarget, BlockPos> reachabilityPredicate = (entity, target, pos) -> entity.f_19815_.m_20393_(pos.m_252807_()).m_82377_(0.5, 0.5, 0.5).m_82390_(target.m_26420_().m_7024_());

    public SetItemWalkTarget<E> predicate(BiPredicate<E, ItemEntity> predicate) {
        this.predicate = predicate;
        return this;
    }

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean checkOtherStartingConditions(ServerLevel level, E entity) {
        Map blocks;
        List<ItemEntity> items = ((List)BrainUtils.getMemory(entity, (MemoryModuleType)((MemoryModuleType)SBLMemoryTypes.NEARBY_ITEMS.get()))).stream().filter(item -> entity.getInventory().canFitItemStack(item.m_32055_())).toList();
        if (items.isEmpty()) {
            return false;
        }
        if (items.size() >= 3) {
            return true;
        }
        RegistryObject<MemoryModuleType<Map<BlockPos, Block>>> registryObject = MemoryModuleTypes.ASYNC_NEAREST_WANTED_BLOCKS;
        synchronized (registryObject) {
            blocks = (Map)BrainUtils.getMemory(entity, (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.ASYNC_NEAREST_WANTED_BLOCKS.get()));
        }
        if (blocks == null || blocks.isEmpty()) {
            return true;
        }
        List<BlockPos> nearbyWanted = blocks.keySet().stream().filter(blockPos -> blockPos.m_203193_((Position)entity.m_20182_()) < 16.0).limit(3L).toList();
        return nearbyWanted.size() < 3;
    }

    @Override
    @NonNull
    protected List<MtzWalkTarget> getPathfindingTargets(ServerLevel level, E entity) {
        List items = (List)BrainUtils.getMemory(entity, (MemoryModuleType)((MemoryModuleType)SBLMemoryTypes.NEARBY_ITEMS.get()));
        return items.stream().filter(item -> this.predicate.test(entity, (ItemEntity)item)).map(item -> new MtzWalkTarget((Entity)item, 1.0f, Math.sqrt(2.0)).withPredicate(this.reachabilityPredicate)).limit(10L).toList();
    }

    @Override
    protected boolean shouldKeepRunning(E entity) {
        EntityTracker tracker = (EntityTracker)this.pathfindingTarget.m_26420_();
        if (tracker.m_147481_().m_213877_()) {
            return false;
        }
        if (entity.m_20191_().m_82377_(1.0, 0.5, 1.0).m_82390_(tracker.m_7024_())) {
            return super.shouldKeepRunning(entity);
        }
        return this.pathfindingTarget.equals(BrainUtils.getMemory(entity, (MemoryModuleType)MemoryModuleType.f_26370_)) && (((ServerCompanionEntity)entity).getPathFinder().getPath() == null || ((ServerCompanionEntity)entity).getPathFinder().didSucceed());
    }

    @Override
    protected void stop(E entity) {
        BrainUtils.clearMemory(entity, (MemoryModuleType)MemoryModuleType.f_26370_);
    }

    private boolean isItemOnTreeLeaf(ItemEntity itemEntity) {
        BlockState onBlock = itemEntity.m_20075_();
        return onBlock.m_60734_() instanceof LeavesBlock && (Boolean)onBlock.m_61143_((Property)LeavesBlock.f_54419_) == false;
    }
}

