/*
 * Decompiled with CFR 0.152.
 */
package com.metropolize.mtz_companions.entity.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import com.metropolize.mtz_companions.entity.data.CompanionNPCData;
import com.metropolize.mtz_companions.entity.data.DialogueTreeData;
import com.metropolize.mtz_companions.entity.data.JsonTaggable;
import com.metropolize.mtz_companions.entity.data.NPCData;
import com.metropolize.mtz_companions.entity.data.decisions.DecisionData;
import com.metropolize.mtz_companions.entity.data.triggers.ast.Node;
import com.metropolize.mtz_companions.entity.metropolize.CompanionState;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BinaryOperator;
import java.util.stream.Collectors;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;

public class ASTCompanionNPCData
extends CompanionNPCData
implements JsonTaggable {
    @SerializedName(value="memory_settings")
    public DecisionData[] memorySettings;

    public ASTCompanionNPCData(UUID uuid, UUID default_dialogue, DecisionData[] activityCalls, DecisionData[] memorySettings, NPCData npcData, DecisionData[] triggerableDialogues) {
        this.uuid = uuid;
        this.default_dialogue = default_dialogue;
        this.activityCalls = activityCalls;
        this.memorySettings = memorySettings;
        this.npcData = npcData;
        this.triggerableDialogues = triggerableDialogues;
    }

    @Override
    public List<DecisionData> getValidActivities(CompanionState state) {
        ArrayList<DecisionData> validActivities = new ArrayList<DecisionData>(Arrays.stream(this.activityCalls).filter(decisionData -> decisionData.conditionsMet(state)).toList());
        validActivities.add(new DecisionData("idle", null));
        return validActivities;
    }

    @Override
    public List<DialogueTreeData> getTriggeredDialogues(CompanionState state) {
        List<DecisionData> validDialogues = Arrays.stream(this.triggerableDialogues).filter(decisionData -> decisionData.conditionsMet(state)).toList();
        return validDialogues.stream().map(decisionData -> this.npcData.dialogue_dict.get(decisionData.getDialogue())).toList();
    }

    @Override
    public Map<MemoryModuleType<?>, Object> getValidMemories(CompanionState state) {
        if (this.memorySettings == null) {
            return null;
        }
        BinaryOperator mapMergeFunction = (existing, replacement) -> {
            if (existing instanceof Collection) {
                ((Collection)existing).addAll((Collection)replacement);
            }
            return existing;
        };
        return Arrays.stream(this.memorySettings).filter(memorySettingDecision -> memorySettingDecision.conditionsMet(state)).collect(Collectors.toUnmodifiableMap(memorySettingDecision -> memorySettingDecision.getMemory().getMemoryModule(), memorySettingDecision -> memorySettingDecision.getMemory().getValue(), mapMergeFunction));
    }

    @Override
    public String createTag() {
        Gson gson = ASTCompanionNPCData.getGson();
        return gson.toJson((Object)this);
    }

    public static Gson getGson() {
        GsonBuilder gsonBldr = new GsonBuilder();
        gsonBldr.registerTypeAdapter(Node.class, (Object)new Node.NodeDataDeserializer());
        return gsonBldr.create();
    }
}

