/*
 * Decompiled with CFR 0.152.
 */
package com.metropolize.mtz_companions.entity.data;

import com.google.gson.annotations.SerializedName;
import com.metropolize.mtz_companions.entity.data.DialogueTreeData;
import com.metropolize.mtz_companions.entity.data.NPCData;
import com.metropolize.mtz_companions.entity.data.decisions.DecisionData;
import com.metropolize.mtz_companions.entity.metropolize.CompanionState;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;

public abstract class CompanionNPCData {
    public UUID uuid;
    public UUID default_dialogue;
    @SerializedName(value="activity_calls")
    public DecisionData[] activityCalls;
    @SerializedName(value="triggerable_dialogues")
    public DecisionData[] triggerableDialogues;
    @SerializedName(value="npc_data")
    public NPCData npcData;

    public abstract List<DecisionData> getValidActivities(CompanionState var1);

    public abstract List<DialogueTreeData> getTriggeredDialogues(CompanionState var1);

    public abstract Map<MemoryModuleType<?>, Object> getValidMemories(CompanionState var1);

    public DialogueTreeData lookupDialogue(UUID uuid) {
        if (uuid == null) {
            return null;
        }
        return this.npcData.dialogue_dict.get(uuid);
    }

    public UUID getDefaultDialogue() {
        return this.default_dialogue;
    }

    public String getName() {
        return this.npcData.name;
    }

    public String getBackstory() {
        return this.npcData.backstory;
    }

    public abstract String createTag();
}

