/*
 * Decompiled with CFR 0.152.
 */
package com.metropolize.mtz_companions.entity.data;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;

public final class DataUtils {
    private static final Logger log = LogUtils.getLogger();

    private DataUtils() {
    }

    public static List<String> parseList(String list) {
        if (!list.strip().matches("\\[.*\\]")) {
            throw new IllegalArgumentException("List must be in the form [item1, item2, ...]");
        }
        list = list.replaceFirst("^\\[", "");
        list = list.replaceFirst("]$", "");
        ArrayList<String> items = new ArrayList<String>(List.of(list.split(",(?=(?:[^\"]*\"[^\"]*\")*[^\"]*$)")));
        items.replaceAll(String::strip);
        if (items.stream().anyMatch(s -> !s.strip().matches("\".*\""))) {
            throw new IllegalArgumentException("Malformed list provided; expected items to be enclosed in double quotes, but got " + String.valueOf(items));
        }
        items.replaceAll(s -> s.replaceFirst("^\"", "").replaceFirst("\"$", ""));
        return items;
    }

    public static Map<String, String> parseDictionary(String dictionary) {
        String[] pairs;
        HashMap<String, String> result = new HashMap<String, String>();
        if (dictionary == null || dictionary.isEmpty()) {
            return result;
        }
        if (!dictionary.strip().matches("\\{.*}")) {
            throw new IllegalArgumentException("Dictionary must be in the form { key1: value1, key2: value2, ... }");
        }
        dictionary = dictionary.replaceFirst("^\\{", "").replaceFirst("}$", "");
        for (String pair : pairs = dictionary.split(",(?=(?:[^']*'[^']*')*[^']*$)")) {
            String[] kv = pair.split(":", 2);
            if (kv.length != 2) {
                throw new IllegalArgumentException("Invalid dictionary entry: " + pair);
            }
            String key = kv[0].trim().replaceAll("^'+|'+$", "");
            String value = kv[1].trim().replaceAll("^'+|'+$", "");
            result.put(key, value);
        }
        return result;
    }

    public static Set<String> parseSet(String set) {
        return Set.copyOf(DataUtils.parseList(set));
    }

    public static class DefaultDataDeserializer<P>
    implements JsonDeserializer<P> {
        private final Type typeOfP;

        public DefaultDataDeserializer(Type typeOfP) {
            this.typeOfP = typeOfP;
        }

        public P deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObject = json.getAsJsonObject();
            return (P)context.deserialize((JsonElement)jsonObject, this.typeOfP);
        }
    }
}

