/*
 * Decompiled with CFR 0.152.
 */
package com.metropolize.mtz_companions.entity.data.memories;

import com.metropolize.mtz_companions.entity.data.memories.Parser;
import com.metropolize.mtz_companions.navigation.MtzWalkTarget;
import com.metropolize.mtz_companions.navigation.path.Path;
import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public abstract class MemoryModuleTypes {
    public static final HashMap<String, Function<String, ?>> MEMORY_PARSERS = new HashMap();
    public static final DeferredRegister<MemoryModuleType<?>> MEMORIES = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.MEMORY_MODULE_TYPES, (String)"mtz_companions");
    public static final RegistryObject<MemoryModuleType<Set<Item>>> WANTED_ITEMS = MemoryModuleTypes.registerMutable("wanted_items", Parser.ITEMS_OR_GROUPS);
    public static final RegistryObject<MemoryModuleType<Boolean>> WANTS_TO_EXPLORE = MemoryModuleTypes.registerMutable("wants_to_explore", Parser.BOOLEAN);
    public static final RegistryObject<MemoryModuleType<Boolean>> WANTS_TO_EXPLORE_CAVE = MemoryModuleTypes.registerMutable("wants_to_explore_cave", Parser.BOOLEAN);
    public static final RegistryObject<MemoryModuleType<Boolean>> WANTS_TO_RETURN_HOME = MemoryModuleTypes.registerMutable("wants_to_return_home", Parser.BOOLEAN);
    public static final RegistryObject<MemoryModuleType<Long>> LAST_EXPLORE_TIME = MemoryModuleTypes.register("last_explored");
    public static final RegistryObject<MemoryModuleType<Integer>> NEXT_EXPLORE_DELAY_TICKS = MemoryModuleTypes.register("time_until_explore");
    public static final RegistryObject<MemoryModuleType<MtzWalkTarget>> PATHFINDING_TETHER = MemoryModuleTypes.register("pathfinding_tether");
    public static final RegistryObject<MemoryModuleType<Stream<BlockPos>>> NEAREST_VISIBLE_CAVES = MemoryModuleTypes.register("nearest_visible_caves");
    public static final RegistryObject<MemoryModuleType<BlockPos>> BLOCK_TARGET = MemoryModuleTypes.register("block_target");
    public static final RegistryObject<MemoryModuleType<ItemStack>> USE_TARGET = MemoryModuleTypes.register("use_target");
    public static final RegistryObject<MemoryModuleType<Pair<Recipe<?>, List<Item>>>> CRAFTING_TARGET = MemoryModuleTypes.register("crafting_target");
    public static final RegistryObject<MemoryModuleType<Item>> PREVIOUS_CRAFTING_TARGET = MemoryModuleTypes.register("prev_crafting_target");
    public static final RegistryObject<MemoryModuleType<ItemStack>> BLOCK_PLACE_ITEM = MemoryModuleTypes.register("block_place_item");
    public static final RegistryObject<MemoryModuleType<BlockPos>> BLOCK_PLACE_POS = MemoryModuleTypes.register("block_place_pos");
    public static final RegistryObject<MemoryModuleType<Pair<BlockPos, BlockState>>> CRAFTING_BLOCK_CLEANUP_TARGET = MemoryModuleTypes.register("block_cleanup_target");
    public static final RegistryObject<MemoryModuleType<Boolean>> CRAFTING_BLOCK_CLEANUP_DELAY = MemoryModuleTypes.register("block_cleanup_delay");
    public static final RegistryObject<MemoryModuleType<Boolean>> SLEEP_COOLING_DOWN = MemoryModuleTypes.register("sleep_cooling_down");
    public static final RegistryObject<MemoryModuleType<ItemStack>> MAINHAND_TARGET = MemoryModuleTypes.register("main_hand_target");
    public static final RegistryObject<MemoryModuleType<ItemStack>> OFFHAND_TARGET = MemoryModuleTypes.register("off_hand_target");
    public static final RegistryObject<MemoryModuleType<List<BlockPos>>> KNOWN_BEDS = MemoryModuleTypes.register("known_beds");
    public static final Supplier<MemoryModuleType<List<BlockPos>>> NEAREST_AVAILABLE_BEDS = MemoryModuleTypes.register("nearest_available_beds");
    public static final Supplier<MemoryModuleType<BlockPos>> BED_TARGET = MemoryModuleTypes.register("bed_target");
    public static final Supplier<MemoryModuleType<Integer>> CHUNKS_TO_EXPLORE = MemoryModuleTypes.register("chunks_to_explore");
    public static final Supplier<MemoryModuleType<BlockPos>> INTERACTION_TARGET = MemoryModuleTypes.register("interaction_target");
    public static final Supplier<MemoryModuleType<Path>> PATH = MemoryModuleTypes.register("path");
    public static final RegistryObject<MemoryModuleType<List<LivingEntity>>> NEAREST_ENEMIES = MemoryModuleTypes.register("nearest_hostiles");
    public static final RegistryObject<MemoryModuleType<Map<BlockPos, Block>>> ASYNC_NEAREST_WANTED_BLOCKS = MemoryModuleTypes.register("nearest_wanted_blocks");
    public static final RegistryObject<MemoryModuleType<List<BlockPos>>> ASYNC_NEAREST_CHESTS = MemoryModuleTypes.register("nearest_chests");
    public static final RegistryObject<MemoryModuleType<List<BlockPos>>> ASYNC_NEAREST_FURNACES = MemoryModuleTypes.register("nearest_furnaces");
    public static final RegistryObject<MemoryModuleType<List<BlockPos>>> ASYNC_KNOWN_CRAFTING_TABLES = MemoryModuleTypes.register("known_crafting_tables");
    public static final RegistryObject<MemoryModuleType<List<BlockPos>>> ASYNC_NEAREST_CAVES = MemoryModuleTypes.register("nearest_caves");

    private MemoryModuleTypes() {
    }

    private static <U> RegistryObject<MemoryModuleType<U>> registerMutable(String id, Parser<? extends U> parser) {
        MEMORY_PARSERS.put(id, parser);
        return MemoryModuleTypes.register(id);
    }

    private static <U> RegistryObject<MemoryModuleType<U>> register(String id) {
        return MEMORIES.register(id, () -> new MemoryModuleType(Optional.empty()));
    }
}

