/*
 * Decompiled with CFR 0.152.
 */
package com.metropolize.mtz_companions.entity.data.memories;

import com.metropolize.mtz_companions.entity.data.DataUtils;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;

@FunctionalInterface
public interface Parser<U>
extends Function<String, U> {
    public static final Parser<Boolean> BOOLEAN = s -> s.equals("true");
    public static final Parser<List<String>> LIST = DataUtils::parseList;
    public static final Parser<Item> ITEM = itemName -> {
        ResourceLocation resourceLocation = new ResourceLocation(itemName);
        if (ForgeRegistries.ITEMS.containsKey(resourceLocation)) {
            return (Item)ForgeRegistries.ITEMS.getValue(resourceLocation);
        }
        return null;
    };
    public static final Parser<Block> BLOCK = blockName -> {
        ResourceLocation resourceLocation = new ResourceLocation(blockName);
        if (ForgeRegistries.BLOCKS.containsKey(resourceLocation)) {
            return (Block)ForgeRegistries.BLOCKS.getValue(resourceLocation);
        }
        return null;
    };
    public static final Parser<List<Item>> ITEM_GROUP = tag -> {
        TagKey tagKey = TagKey.m_203882_((ResourceKey)ForgeRegistries.ITEMS.getRegistryKey(), (ResourceLocation)new ResourceLocation(tag));
        if (ForgeRegistries.ITEMS.tags().isKnownTagName(tagKey)) {
            return ForgeRegistries.ITEMS.tags().getTag(tagKey).stream().toList();
        }
        return null;
    };
    public static final Parser<List<Item>> ITEM_OR_GROUP = s -> {
        List itemList = (List)ITEM_GROUP.apply(s);
        if (itemList != null) {
            return itemList;
        }
        Item item = (Item)ITEM.apply(s);
        if (item != null) {
            return List.of(item);
        }
        return List.of();
    };
    public static final Parser<Set<Item>> ITEMS_OR_GROUPS = s -> ((List)LIST.apply(s)).stream().map(ITEM_OR_GROUP).flatMap(Collection::stream).collect(Collectors.toSet());
    public static final Parser<EntityType<?>> ENTITY_TYPE = entity -> {
        ResourceLocation resourceLocation = new ResourceLocation(entity);
        if (ForgeRegistries.ENTITY_TYPES.containsKey(resourceLocation)) {
            return (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(resourceLocation);
        }
        return null;
    };
}

