/*
 * Decompiled with CFR 0.152.
 */
package com.metropolize.mtz_companions.entity.data.triggers.ast;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import com.metropolize.mtz_companions.entity.data.triggers.ast.BoolOp;
import com.metropolize.mtz_companions.entity.data.triggers.ast.Call;
import com.metropolize.mtz_companions.entity.data.triggers.ast.Compare;
import com.metropolize.mtz_companions.entity.data.triggers.ast.Constant;
import com.metropolize.mtz_companions.entity.data.triggers.ast.Expression;
import com.metropolize.mtz_companions.entity.data.triggers.ast.Keyword;
import com.metropolize.mtz_companions.entity.data.triggers.ast.ListNode;
import com.metropolize.mtz_companions.entity.data.triggers.ast.Name;
import com.metropolize.mtz_companions.entity.data.triggers.ast.UnaryOp;
import com.metropolize.mtz_companions.entity.data.triggers.ast.operator.BoolOpOp;
import com.metropolize.mtz_companions.entity.data.triggers.ast.operator.CompOp;
import com.metropolize.mtz_companions.entity.data.triggers.ast.operator.UnaryOpOp;
import com.metropolize.mtz_companions.entity.metropolize.CompanionState;
import java.lang.reflect.Type;
import java.util.List;

public abstract class Node {
    public abstract Object eval(CompanionState var1);

    public static class NodeDataDeserializer
    implements JsonDeserializer<Node> {
        public Node deserialize(JsonElement jElement, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jObject = jElement.getAsJsonObject();
            String _type = jObject.get("_type").getAsString();
            Type listNodeType = new TypeToken<List<Node>>(){}.getType();
            return switch (_type) {
                case "Constant" -> new Constant(jObject.get("value").getAsString());
                case "Name" -> new Name(jObject.get("id").getAsString());
                case "Compare" -> {
                    Node left = (Node)context.deserialize(jObject.get("left"), Node.class);
                    List comparators = (List)context.deserialize(jObject.get("comparators"), listNodeType);
                    List ops = (List)context.deserialize(jObject.get("ops"), listNodeType);
                    yield new Compare(left, comparators, ops);
                }
                case "Call" -> {
                    Name func = (Name)context.deserialize(jObject.get("func"), Name.class);
                    List args = (List)context.deserialize(jObject.get("args"), listNodeType);
                    List keywords = (List)context.deserialize(jObject.get("keywords"), listNodeType);
                    yield new Call(func, args, keywords);
                }
                case "keyword" -> {
                    String arg = jObject.get("arg").getAsString();
                    Node value = (Node)context.deserialize(jObject.get("value"), Node.class);
                    yield new Keyword(arg, value);
                }
                case "BoolOp" -> {
                    List values = (List)context.deserialize(jObject.get("values"), listNodeType);
                    BoolOpOp op = (BoolOpOp)context.deserialize(jObject.get("op"), Node.class);
                    yield new BoolOp(values, op);
                }
                case "USub" -> new UnaryOpOp.USub();
                case "UnaryOp" -> {
                    UnaryOpOp op = (UnaryOpOp)context.deserialize(jObject.get("op"), Node.class);
                    Node operand = (Node)context.deserialize(jObject.get("operand"), Node.class);
                    yield new UnaryOp(op, operand);
                }
                case "List" -> {
                    List elts = (List)context.deserialize(jObject.get("elts"), listNodeType);
                    yield new ListNode(elts);
                }
                case "And" -> new BoolOpOp.And();
                case "Or" -> new BoolOpOp.Or();
                case "Eq" -> new CompOp.Eq();
                case "NotEq" -> new CompOp.NotEq();
                case "Lt" -> new CompOp.Lt();
                case "LtE" -> new CompOp.LtE();
                case "Gt" -> new CompOp.Gt();
                case "GtE" -> new CompOp.GtE();
                case "In" -> new CompOp.In();
                case "NotIn" -> new CompOp.NotIn();
                case "Expression" -> {
                    Node body = (Node)context.deserialize(jObject.get("body"), Node.class);
                    yield new Expression(body);
                }
                default -> null;
            };
        }
    }
}

