/*
 * Decompiled with CFR 0.152.
 */
package com.metropolize.mtz_companions.entity.data.triggers.ast.operator;

import com.metropolize.mtz_companions.entity.data.triggers.ast.Node;
import com.metropolize.mtz_companions.entity.metropolize.CompanionState;
import java.util.List;

public abstract class CompOp
extends Node {
    public static final double eps = 0.001;

    public abstract boolean apply(Object var1, List<Object> var2);

    private static void checkSize(List<Object> comparators) {
        if (comparators.size() != 1) {
            throw new UnsupportedOperationException("Comparison operator must have exactly one comparator");
        }
    }

    @Override
    public Object eval(CompanionState state) {
        return this;
    }

    private static double getDouble(Object o) {
        if (o instanceof String) {
            return Double.parseDouble((String)o);
        }
        return ((Number)o).doubleValue();
    }

    public static class NotIn
    extends CompOp {
        public final String _type = "NotIn";

        @Override
        public boolean apply(Object left, List<Object> comparators) {
            In in = new In();
            return !in.apply(left, comparators);
        }
    }

    public static class In
    extends CompOp {
        public final String _type = "In";

        @Override
        public boolean apply(Object left, List<Object> comparators) {
            Eq eq = new Eq();
            return comparators.stream().anyMatch(comparator -> eq.apply(left, List.of(comparator)));
        }
    }

    public static class LtE
    extends CompOp {
        public final String _type = "LtE";

        @Override
        public boolean apply(Object left, List<Object> comparators) {
            CompOp.checkSize(comparators);
            Gt gt = new Gt();
            return !gt.apply(left, comparators);
        }
    }

    public static class Lt
    extends CompOp {
        public final String _type = "Lt";

        @Override
        public boolean apply(Object left, List<Object> comparators) {
            CompOp.checkSize(comparators);
            GtE gtE = new GtE();
            return !gtE.apply(left, comparators);
        }
    }

    public static class GtE
    extends CompOp {
        public final String _type = "GtE";

        @Override
        public boolean apply(Object left, List<Object> comparators) {
            CompOp.checkSize(comparators);
            double d1 = CompOp.getDouble(left);
            double d2 = CompOp.getDouble(comparators.get(0));
            return d1 - d2 > -0.001;
        }
    }

    public static class Gt
    extends CompOp {
        public final String _type = "Gt";

        @Override
        public boolean apply(Object left, List<Object> comparators) {
            CompOp.checkSize(comparators);
            double d1 = CompOp.getDouble(left);
            double d2 = CompOp.getDouble(comparators.get(0));
            return d1 > d2;
        }
    }

    public static class NotEq
    extends CompOp {
        public final String _type = "NotEq";

        @Override
        public boolean apply(Object left, List<Object> comparators) {
            CompOp.checkSize(comparators);
            Eq eq = new Eq();
            return !eq.apply(left, comparators);
        }
    }

    public static class Eq
    extends CompOp {
        public final String _type = "Eq";

        @Override
        public boolean apply(Object left, List<Object> comparators) {
            CompOp.checkSize(comparators);
            if (left instanceof Number && comparators.get(0) instanceof Number) {
                double d2;
                double d1 = CompOp.getDouble(left);
                return Math.abs(d1 - (d2 = CompOp.getDouble(comparators.get(0)))) < 0.001;
            }
            return left.equals(comparators.get(0));
        }
    }
}

