/*
 * Decompiled with CFR 0.152.
 */
package com.metropolize.mtz_companions.entity.metropolize;

import com.metropolize.mtz_companions.entity.CompanionContainer;
import com.metropolize.mtz_companions.entity.ServerCompanionEntity;
import com.metropolize.mtz_companions.entity.data.memories.MemoryModuleTypes;
import com.metropolize.mtz_companions.entity.data.memories.Parser;
import com.metropolize.mtz_companions.entity.metropolize.EntityInfo;
import com.metropolize.mtz_companions.entity.metropolize.MtzGson;
import com.metropolize.mtzcharacterengine.MtzActivity;
import com.metropolize.mtzcharacterengine.MtzBrainOwner;
import com.metropolize.mtzcharacterengine.registry.SBLMemoryTypes;
import com.metropolize.mtzcharacterengine.util.BrainUtils;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.RegistryObject;
import org.slf4j.Logger;

public class CompanionState {
    private static final Logger log = LogUtils.getLogger();
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    private final transient ServerCompanionEntity entity;
    private final MtzActivity currentActivity;
    private final float health;
    private final int foodLevel;
    private final Vec3 position;
    private final String biome;
    private final float dayTime;
    private final boolean wantsToReturnHome;
    private final boolean wantsToExplore;
    private final boolean canSeePlayer;
    private final double playerDistance;
    private final float playerHealth;
    private final float playerFoodLevel;
    private final double distanceToNearestWantedBlock;
    private final double distanceToNearestEnemy;
    private final double distanceToNearestHostile;
    private final List<Item> nearbyItems;
    private final int nearbyItemCount;
    private final Map<Item, Integer> inventoryItemCount;
    private final CompanionContainer inventory;
    private final List<Item> wantedItems;
    private final boolean canCraft;
    private final List<EntityType<?>> nearbyMobs = new ArrayList();
    private final List<EntityInfo> nearbyLivingEntities = new ArrayList<EntityInfo>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompanionState(ServerCompanionEntity entity) {
        this.entity = entity;
        this.position = entity.m_20182_();
        this.biome = ((ResourceKey)entity.m_9236_().m_204166_(entity.m_20183_()).m_203543_().orElseThrow()).toString();
        this.currentActivity = entity.getMtzBrain().getCurrentActivity();
        this.foodLevel = entity.m_36324_().m_38702_();
        this.health = entity.m_21223_();
        List nearestEnemies = (List)BrainUtils.memoryOrDefault((MtzBrainOwner)entity, (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.NEAREST_ENEMIES.get()), List::of);
        this.distanceToNearestEnemy = !nearestEnemies.isEmpty() ? (double)entity.m_20270_((Entity)nearestEnemies.get(0)) : Double.POSITIVE_INFINITY;
        this.distanceToNearestHostile = nearestEnemies.stream().filter(e -> {
            Mob mob;
            return e instanceof Mob && (mob = (Mob)e).m_5448_() == entity;
        }).map(arg_0 -> ((ServerCompanionEntity)entity).m_20270_(arg_0)).findFirst().orElse(Float.valueOf(Float.POSITIVE_INFINITY)).floatValue();
        this.dayTime = entity.m_9236_().m_46468_() % 24000L;
        this.wantsToExplore = entity.wantsToExplore();
        Set<Item> wantedItems = entity.getWantedItems();
        this.wantedItems = wantedItems == null ? new ArrayList<Item>() : wantedItems.stream().toList();
        List nearbyItems = (List)BrainUtils.getMemory((MtzBrainOwner)entity, (MemoryModuleType)((MemoryModuleType)SBLMemoryTypes.NEARBY_ITEMS.get()));
        if (nearbyItems != null && !nearbyItems.isEmpty()) {
            this.nearbyItems = nearbyItems.stream().map(itemEntity -> itemEntity.m_32055_().m_41720_()).toList();
            this.nearbyItemCount = nearbyItems.stream().reduce(0, (count, item) -> item.m_32055_().m_41613_() + count, Integer::sum);
        } else {
            this.nearbyItems = new ArrayList<Item>();
            this.nearbyItemCount = 0;
        }
        RegistryObject<MemoryModuleType<Map<BlockPos, Block>>> registryObject = MemoryModuleTypes.ASYNC_NEAREST_WANTED_BLOCKS;
        synchronized (registryObject) {
            SortedMap nearestWantedBlocks = (SortedMap)BrainUtils.getMemory((MtzBrainOwner)entity, (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.ASYNC_NEAREST_WANTED_BLOCKS.get()));
            this.distanceToNearestWantedBlock = nearestWantedBlocks != null && !nearestWantedBlocks.isEmpty() ? Math.sqrt(entity.m_20238_(((BlockPos)nearestWantedBlocks.firstKey()).m_252807_())) : Double.POSITIVE_INFINITY;
        }
        List nearbyPlayers = (List)BrainUtils.getMemory((MtzBrainOwner)entity, (MemoryModuleType)MemoryModuleType.f_26367_);
        if (nearbyPlayers != null && !nearbyPlayers.isEmpty()) {
            Player closestPlayer = (Player)nearbyPlayers.get(0);
            this.playerDistance = entity.m_20182_().m_82554_(closestPlayer.m_20182_());
            this.canSeePlayer = entity.m_142582_((Entity)closestPlayer);
            this.playerFoodLevel = closestPlayer.m_36324_().m_38702_();
            this.playerHealth = closestPlayer.m_21223_();
        } else {
            this.playerDistance = Double.POSITIVE_INFINITY;
            this.canSeePlayer = false;
            this.playerFoodLevel = 20.0f;
            this.playerHealth = 20.0f;
        }
        this.inventoryItemCount = entity.getInventory().getItemCounts();
        this.inventory = entity.getInventory();
        this.canCraft = false;
        List nearbyLivingEntities = (List)BrainUtils.getMemory((MtzBrainOwner)entity, (MemoryModuleType)MemoryModuleType.f_148204_);
        if (nearbyLivingEntities != null) {
            this.nearbyLivingEntities.addAll(nearbyLivingEntities.stream().map(EntityInfo::new).toList());
            this.nearbyMobs.addAll(nearbyLivingEntities.stream().filter(e -> e instanceof Mob).map(Entity::m_6095_).toList());
        }
        this.wantsToReturnHome = (Boolean)BrainUtils.memoryOrDefault((MtzBrainOwner)entity, (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.WANTS_TO_RETURN_HOME.get()), () -> false);
    }

    public String toJSON() {
        return MtzGson.INSTANCE.toJson((Object)this);
    }

    public CompanionState(int foodLevel, float health, float dayTime, double distanceToNearestWantedBlock, double playerDistance, boolean canSeePlayer, int nearbyItemCount, float playerHealth, float playerFoodLevel, double distanceToNearestEnemy, double distanceToNearestHostile, boolean canCraft) {
        this.distanceToNearestEnemy = distanceToNearestEnemy;
        this.entity = null;
        this.position = null;
        this.biome = "";
        this.currentActivity = null;
        this.foodLevel = foodLevel;
        this.health = health;
        this.dayTime = dayTime;
        this.distanceToNearestWantedBlock = distanceToNearestWantedBlock;
        this.playerDistance = playerDistance;
        this.canSeePlayer = canSeePlayer;
        this.nearbyItems = new ArrayList<Item>();
        this.nearbyItemCount = nearbyItemCount;
        this.inventoryItemCount = new HashMap<Item, Integer>();
        this.wantedItems = new ArrayList<Item>();
        this.wantsToExplore = false;
        this.playerHealth = playerHealth;
        this.playerFoodLevel = playerFoodLevel;
        this.distanceToNearestHostile = distanceToNearestHostile;
        this.canCraft = canCraft;
        this.inventory = null;
        this.wantsToReturnHome = false;
    }

    public Object nameLookup(String name) {
        return switch (name) {
            case "canSeePlayer" -> {
                if (this.canSeePlayer) {
                    yield TRUE;
                }
                yield FALSE;
            }
            case "wantsToExplore" -> {
                if (this.wantsToExplore) {
                    yield TRUE;
                }
                yield FALSE;
            }
            case "wantsToReturnHome" -> {
                if (this.wantsToReturnHome) {
                    yield TRUE;
                }
                yield FALSE;
            }
            case "nearbyItems" -> this.nearbyItems.stream().map(Item::m_5524_).toList();
            case "nearbyItemCount" -> this.nearbyItemCount;
            case "foodLevel" -> this.foodLevel;
            case "health" -> Float.valueOf(this.health);
            case "playerDistance" -> this.playerDistance;
            case "dayTime" -> Float.valueOf(this.dayTime);
            case "distanceToNearestWantedBlock" -> this.distanceToNearestWantedBlock;
            case "distanceToNearestHostile" -> this.distanceToNearestHostile;
            case "distanceToNearestEnemy" -> this.distanceToNearestEnemy;
            case "wanted_items" -> this.wantedItems.stream().map(Item::m_5524_).toList();
            case "playerHealth" -> Float.valueOf(this.playerHealth);
            case "playerFoodLevel" -> Float.valueOf(this.playerFoodLevel);
            case "canCraft" -> {
                if (this.canCraft) {
                    yield TRUE;
                }
                yield FALSE;
            }
            case "nearbyMobs" -> this.nearbyMobs.stream().map(mob -> mob.m_20675_().replaceFirst("entity.minecraft.", "")).toList();
            default -> {
                log.error("Variable name {} not found.", (Object)name);
                yield false;
            }
        };
    }

    public Object evaluate(String fnName, Map<String, Object> keywords) {
        return switch (fnName) {
            case "numItemsInInventory" -> {
                if (!$assertionsDisabled && !keywords.containsKey("item")) {
                    throw new AssertionError();
                }
                String itemTag = (String)keywords.get("item");
                yield this.numItemsInInventory(itemTag);
            }
            case "canAddAnyItemsToInventory" -> {
                if (!$assertionsDisabled && !keywords.containsKey("items")) {
                    throw new AssertionError();
                }
                Object var6_9 = keywords.get("items");
                if (var6_9 instanceof List) {
                    List itemsToAdd = (List)var6_9;
                    yield this.canAddAnyItemsToInventory(itemsToAdd);
                }
                throw new IllegalArgumentException("canAddAnyItemsToInventory() takes a list of items as an argument.");
            }
            case "len" -> {
                Object var6_10 = keywords.get("0");
                if (var6_10 instanceof List) {
                    List list = (List)var6_10;
                    yield list.size();
                }
                throw new IllegalArgumentException("len() takes a list as an argument.");
            }
            case "isNearKnownBlock" -> {
                if (!$assertionsDisabled && !keywords.containsKey("block")) {
                    throw new AssertionError();
                }
                String block = (String)keywords.get("block");
                yield this.isNearKnownBlock(block);
            }
            default -> throw new UnsupportedOperationException("Function with name " + fnName + " not found.");
        };
    }

    private int numItemsInInventory(String itemTag) {
        if (itemTag == null) {
            return this.inventoryItemCount.values().stream().reduce(0, Integer::sum);
        }
        List items = (List)Parser.ITEM_OR_GROUP.apply(itemTag);
        if (items != null) {
            return items.stream().mapToInt(item -> Optional.ofNullable(this.inventoryItemCount.get(item)).orElse(0)).sum();
        }
        log.error("Could not parse {} into an existing item or tag.", (Object)itemTag);
        return 0;
    }

    private String canAddAnyItemsToInventory(List<String> itemsToAdd) {
        for (String itemName : itemsToAdd) {
            Item item = (Item)Parser.ITEM.apply(itemName);
            if (item == null) {
                log.error("Item {} not found.", (Object)itemName);
                continue;
            }
            if (!this.inventory.canFitItemStack(new ItemStack((ItemLike)item))) continue;
            return TRUE;
        }
        return FALSE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String isNearKnownBlock(String blockName) {
        Block block = (Block)Parser.BLOCK.apply(blockName);
        if (block == null) {
            log.error("Block {} not found.", (Object)blockName);
            return FALSE;
        }
        if (block == Blocks.f_50091_) {
            List nearestCraftingTables;
            RegistryObject<MemoryModuleType<List<BlockPos>>> registryObject = MemoryModuleTypes.ASYNC_KNOWN_CRAFTING_TABLES;
            synchronized (registryObject) {
                nearestCraftingTables = (List)BrainUtils.getMemory((MtzBrainOwner)this.entity, (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.ASYNC_KNOWN_CRAFTING_TABLES.get()));
            }
            if (nearestCraftingTables == null || nearestCraftingTables.isEmpty() || ((BlockPos)nearestCraftingTables.get(0)).m_123331_((Vec3i)this.entity.m_20183_()) >= Math.pow(32.0, 2.0)) {
                return FALSE;
            }
            return TRUE;
        }
        log.error("isNearKnownBlock called on unsupported block: {}", (Object)blockName);
        return FALSE;
    }
}

