/*
 * Decompiled with CFR 0.152.
 */
package com.metropolize.mtz_companions.entity.metropolize;

import com.metropolize.mtz_companions.MTZRegistries;
import com.metropolize.mtz_companions.MetropolizeMod;
import com.metropolize.mtz_companions.entity.ServerCompanionEntity;
import com.metropolize.mtz_companions.entity.behaviors.AnimatableMeleeAttack;
import com.metropolize.mtz_companions.entity.behaviors.CraftItem;
import com.metropolize.mtz_companions.entity.behaviors.EnterNearbyBoat;
import com.metropolize.mtz_companions.entity.behaviors.HarvestBlockTarget;
import com.metropolize.mtz_companions.entity.behaviors.PlaceTemporaryBlock;
import com.metropolize.mtz_companions.entity.behaviors.ReturnHome;
import com.metropolize.mtz_companions.entity.behaviors.SetAttackTarget;
import com.metropolize.mtz_companions.entity.behaviors.SetCraftingTarget;
import com.metropolize.mtz_companions.entity.behaviors.SetEatTarget;
import com.metropolize.mtz_companions.entity.behaviors.SetHuntingTarget;
import com.metropolize.mtz_companions.entity.behaviors.SetPlacementTarget;
import com.metropolize.mtz_companions.entity.behaviors.SetPlayerWalkTarget;
import com.metropolize.mtz_companions.entity.behaviors.SetToolEquipTarget;
import com.metropolize.mtz_companions.entity.behaviors.SetWalkTargetToAttackTarget;
import com.metropolize.mtz_companions.entity.behaviors.SetWeaponEquipTarget;
import com.metropolize.mtz_companions.entity.behaviors.SleepAtBedTarget;
import com.metropolize.mtz_companions.entity.behaviors.StoreInChestTarget;
import com.metropolize.mtz_companions.entity.behaviors.core.EquipHandTarget;
import com.metropolize.mtz_companions.entity.behaviors.core.UseMainHandItem;
import com.metropolize.mtz_companions.entity.behaviors.movement.Idle;
import com.metropolize.mtz_companions.entity.behaviors.pathfinding.FleeFromCreeper;
import com.metropolize.mtz_companions.entity.behaviors.pathfinding.FleeTowardsHome;
import com.metropolize.mtz_companions.entity.behaviors.pathfinding.SetBedWalkTarget;
import com.metropolize.mtz_companions.entity.behaviors.pathfinding.SetBlockTarget;
import com.metropolize.mtz_companions.entity.behaviors.pathfinding.SetChestTarget;
import com.metropolize.mtz_companions.entity.behaviors.pathfinding.SetExplorationWalkTarget;
import com.metropolize.mtz_companions.entity.behaviors.pathfinding.SetFurnaceTarget;
import com.metropolize.mtz_companions.entity.behaviors.pathfinding.SetItemWalkTarget;
import com.metropolize.mtz_companions.entity.data.memories.MemoryModuleTypes;
import com.metropolize.mtzcharacterengine.MtzActivity;
import com.metropolize.mtzcharacterengine.MtzBrainOwner;
import com.metropolize.mtzcharacterengine.api.core.behaviour.AllApplicableBehaviours;
import com.metropolize.mtzcharacterengine.api.core.behaviour.ExtendedBehaviour;
import com.metropolize.mtzcharacterengine.api.core.behaviour.FirstApplicableBehaviour;
import com.metropolize.mtzcharacterengine.api.core.behaviour.custom.target.InvalidateAttackTarget;
import com.metropolize.mtzcharacterengine.util.BrainUtils;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraftforge.registries.RegistryObject;
import org.slf4j.Logger;

public final class MtzActivities {
    private static final Logger log = LogUtils.getLogger();
    public static final RegistryObject<MtzActivity> IDLE = MtzActivities.register(new MtzActivity("idle", () -> new ExtendedBehaviour[]{new Idle()}));
    public static final RegistryObject<MtzActivity> EAT = MtzActivities.register(new MtzActivity("eat", () -> new ExtendedBehaviour[]{new SetEatTarget(), new EquipHandTarget(), new UseMainHandItem()}));
    public static final RegistryObject<MtzActivity> EXPLORE = MtzActivities.register(new MtzActivity("explore", () -> new ExtendedBehaviour[]{new SetExplorationWalkTarget()}));
    public static final RegistryObject<MtzActivity> FOLLOW_PLAYER = MtzActivities.register(new MtzActivity("follow_player", () -> new ExtendedBehaviour[]{new SetPlayerWalkTarget(), new EnterNearbyBoat<ServerCompanionEntity>().setPredicate((entity, boat) -> boat.m_146898_())}));
    public static final RegistryObject<MtzActivity> FLEE = MtzActivities.register(new MtzActivity("flee", () -> new ExtendedBehaviour[]{new FleeTowardsHome()}));
    public static final RegistryObject<MtzActivity> HARVEST_BLOCKS = MtzActivities.register(new MtzActivity("harvest_blocks", () -> new ExtendedBehaviour[]{new SetBlockTarget(), new SetToolEquipTarget(), new EquipHandTarget(), new HarvestBlockTarget()}));
    public static final RegistryObject<MtzActivity> PICK_UP = MtzActivities.register(new MtzActivity("pick_up", () -> new ExtendedBehaviour[]{new SetItemWalkTarget()}));
    public static final RegistryObject<MtzActivity> HUNT = MtzActivities.register(new MtzActivity("hunt", () -> new ExtendedBehaviour[]{new SetHuntingTarget(), new SetWeaponEquipTarget(), new SetWalkTargetToAttackTarget(), new AnimatableMeleeAttack<ServerCompanionEntity>(0).attackInterval(entity -> 10)}));
    public static final RegistryObject<MtzActivity> FIGHT = MtzActivities.register(new MtzActivity("fight", () -> new ExtendedBehaviour[]{new SetAttackTarget(), new SetWeaponEquipTarget(), new EquipHandTarget(), new EquipHandTarget().offhand(), new InvalidateAttackTarget(), new FirstApplicableBehaviour(new ExtendedBehaviour[]{new FleeFromCreeper(), new AllApplicableBehaviours(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget(), new AnimatableMeleeAttack<ServerCompanionEntity>(0).attackInterval(entity -> 10)})})}));
    public static final RegistryObject<MtzActivity> SLEEP = MtzActivities.register(() -> {
        MtzActivity activity = new MtzActivity("sleep", () -> new ExtendedBehaviour[]{new SetBedWalkTarget(), new SleepAtBedTarget()});
        activity.stopPredicate = e -> !e.m_5803_() && ((ServerCompanionEntity)e).canContinueSleep();
        return activity;
    });
    public static final RegistryObject<MtzActivity> CRAFT = MtzActivities.register(new MtzActivity("craft", () -> new ExtendedBehaviour[]{new SetCraftingTarget(), new SetPlacementTarget().cooldownFor(e -> 20), new PlaceTemporaryBlock().whenStopping(e -> {
        RegistryObject<MemoryModuleType<List<BlockPos>>> registryObject = MemoryModuleTypes.ASYNC_KNOWN_CRAFTING_TABLES;
        synchronized (registryObject) {
            List craftingTables = (List)BrainUtils.getMemory((MtzBrainOwner)e, (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.ASYNC_KNOWN_CRAFTING_TABLES.get()));
            ArrayList<BlockPos> newCraftingTables = craftingTables != null ? new ArrayList<BlockPos>(craftingTables) : new ArrayList();
            newCraftingTables.add((BlockPos)BrainUtils.getMemory((MtzBrainOwner)e, (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.BLOCK_PLACE_POS.get())));
            BrainUtils.setMemory((MtzBrainOwner)e, (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.ASYNC_KNOWN_CRAFTING_TABLES.get()), newCraftingTables);
        }
    }), new CraftItem()}));
    public static final RegistryObject<MtzActivity> RETURN_HOME = MtzActivities.register(new MtzActivity("return_home", () -> new ExtendedBehaviour[]{new ReturnHome()}));
    public static final RegistryObject<MtzActivity> STORE_IN_CHEST = MtzActivities.register(new MtzActivity("store_in_chest", () -> new ExtendedBehaviour[]{new SetChestTarget(), new StoreInChestTarget()}));
    public static final RegistryObject<MtzActivity> USE_FURNACE = MtzActivities.register(new MtzActivity("use_furnace", () -> new ExtendedBehaviour[]{new SetFurnaceTarget()}));

    public static void init() {
    }

    public static MtzActivity getActivity(String name) {
        return (MtzActivity)MTZRegistries.ACTIVITIES.get().getValue(new ResourceLocation("mtz_companions", name));
    }

    public static Collection<MtzActivity> getAll() {
        return MTZRegistries.ACTIVITIES.get().getValues();
    }

    private static RegistryObject<MtzActivity> register(MtzActivity activity) {
        return MetropolizeMod.ACTIVITIES.register(activity.getName(), () -> activity);
    }

    private static RegistryObject<MtzActivity> register(Supplier<MtzActivity> activitySupplier) {
        MtzActivity activity = activitySupplier.get();
        return MetropolizeMod.ACTIVITIES.register(activity.getName(), () -> activity);
    }
}

