/*
 * Decompiled with CFR 0.152.
 */
package com.metropolize.mtz_companions.entity.metropolize;

import com.metropolize.mtz_companions.entity.data.CompanionNPCData;
import com.metropolize.mtz_companions.entity.data.DialogueTreeData;
import com.metropolize.mtz_companions.entity.data.decisions.DecisionData;
import com.metropolize.mtz_companions.entity.metropolize.CompanionState;
import com.metropolize.mtz_companions.entity.metropolize.MtzActivities;
import com.metropolize.mtzcharacterengine.MtzActivity;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import org.slf4j.Logger;

public class MtzController {
    private static final Logger log = LogUtils.getLogger();
    protected ResourceLocation resourceLocation;
    protected CompanionNPCData data;
    protected DialogueTreeData currentDialogue;
    protected MtzActivity overrideActivity = null;
    protected int overrideTicks = -1;

    public MtzController(ResourceLocation resourceLocation, CompanionNPCData data) {
        this.resourceLocation = resourceLocation;
        this.data = data;
    }

    public String getName() {
        return this.data.getName();
    }

    public void tick() {
        if (this.overrideActivity != null && this.overrideTicks > 0) {
            --this.overrideTicks;
            if (this.overrideTicks == 0) {
                this.overrideActivity = null;
            }
        }
    }

    public void setOverrideActivity(MtzActivity activity, int durationInTicks) {
        this.overrideActivity = activity;
        this.overrideTicks = activity == null ? 0 : durationInTicks;
    }

    public List<MtzActivity> getActivities(CompanionState state) {
        if (this.overrideActivity != null) {
            return List.of(this.overrideActivity, (MtzActivity)MtzActivities.IDLE.get());
        }
        List<DecisionData> activityInfos = this.data.getValidActivities(state);
        return activityInfos.stream().map(e -> MtzActivities.getActivity(e.getActivity())).filter(Objects::nonNull).toList();
    }

    public Map<MemoryModuleType<?>, Object> getMemories(CompanionState state) {
        return this.data.getValidMemories(state);
    }

    public List<DialogueTreeData> getTriggeredDialogues(CompanionState state) {
        return this.data.getTriggeredDialogues(state);
    }

    public Pair<String, String[]> getDialogueAndChoices(int choice) {
        if (this.currentDialogue == null) {
            this.currentDialogue = this.data.lookupDialogue(this.data.getDefaultDialogue());
        } else {
            if (choice >= this.currentDialogue.children.length || choice < 0) {
                log.warn("Invalid choice: " + choice + " for dialogue: " + String.valueOf(this.currentDialogue));
                return null;
            }
            this.currentDialogue = this.data.lookupDialogue(this.currentDialogue.children[choice]);
        }
        Pair ret = new Pair((Object)this.currentDialogue.npc_response, (Object)this.currentDialogue.pc_responses);
        if (this.currentDialogue.children.length == 0) {
            this.resetDialogue();
        }
        return ret;
    }

    public Pair<String, String[]> getDialogueAndChoices() {
        if (this.currentDialogue == null) {
            this.currentDialogue = this.data.lookupDialogue(this.data.getDefaultDialogue());
        }
        return new Pair((Object)this.currentDialogue.npc_response, (Object)this.currentDialogue.pc_responses);
    }

    public String formatDialogueAndChoices(Pair<String, String[]> dialogueAndChoices) {
        String dialogue = (String)dialogueAndChoices.getFirst();
        String[] choices = (String[])dialogueAndChoices.getSecond();
        StringBuilder sb = new StringBuilder();
        sb.append(dialogue);
        sb.append("\n");
        if (choices.length > 0) {
            sb.append("Choices:\n");
            for (int i = 0; i < choices.length; ++i) {
                sb.append(i);
                sb.append(": ");
                sb.append(choices[i]);
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    public void resetDialogue() {
        this.currentDialogue = null;
    }

    public String[] getChoices() {
        if (this.currentDialogue == null) {
            return new String[0];
        }
        return this.currentDialogue.pc_responses;
    }

    public String getResponse() {
        return this.currentDialogue.npc_response;
    }

    public boolean validateChoice(int choice) {
        return choice >= 0 && choice < this.currentDialogue.children.length;
    }

    public ResourceLocation getResourceLocation() {
        return this.resourceLocation;
    }

    public MtzActivity getOverrideActivity() {
        return this.overrideActivity;
    }

    public int getOverrideTicks() {
        return this.overrideTicks;
    }
}

