/*
 * Decompiled with CFR 0.152.
 */
package com.metropolize.mtz_companions.entity.sensors;

import com.metropolize.mtz_companions.MetropolizeMod;
import com.metropolize.mtz_companions.core.MetropolizeBlockPos;
import com.metropolize.mtz_companions.core.MtzBlockStateProperties;
import com.metropolize.mtz_companions.entity.ServerCompanionEntity;
import com.metropolize.mtz_companions.entity.data.memories.MemoryModuleTypes;
import com.metropolize.mtz_companions.entity.sensors.MtzSensors;
import com.metropolize.mtz_companions.navigation.utils.MovementUtils;
import com.metropolize.mtzcharacterengine.api.core.sensor.ExtendedSensor;
import com.metropolize.mtzcharacterengine.api.core.sensor.PredicateSensor;
import com.metropolize.mtzcharacterengine.util.BrainUtils;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.AbstractCollection;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.RegistryObject;
import org.slf4j.Logger;

public class CaveSensor<E extends ServerCompanionEntity>
extends PredicateSensor<BlockPos, E> {
    private static final Logger log = LogUtils.getLogger();
    private static final List<MemoryModuleType<?>> MEMORIES = ObjectArrayList.of((Object[])new MemoryModuleType[]{(MemoryModuleType)MemoryModuleTypes.WANTS_TO_EXPLORE_CAVE.get(), (MemoryModuleType)MemoryModuleTypes.ASYNC_NEAREST_CAVES.get(), (MemoryModuleType)MemoryModuleTypes.NEAREST_VISIBLE_CAVES.get()});
    public static final Vec3i RADIUS = new Vec3i(16, 8, 16);
    private final Deque<BlockPos> blocksToUpdate = new ArrayDeque<BlockPos>();
    private Future<?> flatteningTask = null;
    private volatile List<BlockPos> unexploredBlocks = null;

    public List<MemoryModuleType<?>> memoriesUsed() {
        return MEMORIES;
    }

    public SensorType<? extends ExtendedSensor<?>> type() {
        return (SensorType)MtzSensors.CAVE_SENSOR.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doTick(ServerLevel level, E entity) {
        if (!((Boolean)BrainUtils.memoryOrDefault(entity, (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.WANTS_TO_EXPLORE_CAVE.get()), () -> false)).booleanValue()) {
            RegistryObject<MemoryModuleType<List<BlockPos>>> registryObject = MemoryModuleTypes.ASYNC_NEAREST_CAVES;
            synchronized (registryObject) {
                BrainUtils.clearMemory(entity, (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.ASYNC_NEAREST_CAVES.get()));
            }
            BrainUtils.clearMemory(entity, (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.NEAREST_VISIBLE_CAVES.get()));
            return;
        }
        if (this.flatteningTask != null && !this.flatteningTask.isDone()) {
            return;
        }
        Object object = this.blocksToUpdate;
        synchronized (object) {
            while (!this.blocksToUpdate.isEmpty()) {
                BlockPos blockPos = this.blocksToUpdate.pop();
                BlockState blockState = level.m_8055_(blockPos);
                if (!blockState.m_60795_()) continue;
                level.m_46597_(blockPos, (BlockState)level.m_8055_(blockPos).m_61124_((Property)MtzBlockStateProperties.CARVED_CAVE, (Comparable)Boolean.valueOf(true)));
            }
        }
        object = this;
        synchronized (object) {
            BrainUtils.setMemory(entity, (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.ASYNC_NEAREST_CAVES.get()), this.unexploredBlocks);
        }
        try {
            this.flatteningTask = MetropolizeMod.EXECUTOR.submit(() -> this.flattenToWalkable(level, (ServerCompanionEntity)entity));
        }
        catch (RejectedExecutionException e) {
            log.error("Executor rejected task: {}", (Object)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flattenToWalkable(ServerLevel level, ServerCompanionEntity entity) {
        Thread.currentThread().setName("MtzAsyncWorker");
        Vec3i front = entity.m_6350_().m_122436_().m_142393_(RADIUS.m_123341_());
        Vec3i side = entity.m_6350_().m_122427_().m_122436_().m_142393_(RADIUS.m_123343_());
        List<BlockPos> blocks = BlockPos.m_121990_((BlockPos)entity.m_20183_().m_121996_(side.m_121955_(front)).m_6625_(RADIUS.m_123342_()), (BlockPos)entity.m_20183_().m_121955_(side.m_121955_(front)).m_6630_(RADIUS.m_123342_())).map(BlockPos::m_7949_).filter(blockPos -> {
            if (Thread.currentThread().isInterrupted() || entity.f_8924_.m_129918_()) {
                return false;
            }
            if (level.m_151570_(blockPos) || level.m_45527_(blockPos)) {
                return false;
            }
            BlockState blockState = level.m_8055_(blockPos);
            if (blockState.m_60713_(Blocks.f_50627_)) {
                Deque<BlockPos> deque = this.blocksToUpdate;
                synchronized (deque) {
                    this.blocksToUpdate.add((BlockPos)blockPos);
                }
                return true;
            }
            return blockState.m_61145_((Property)MtzBlockStateProperties.CARVED_CAVE).orElse(false);
        }).takeWhile(_unused -> !Thread.currentThread().isInterrupted() && !entity.f_8924_.m_129918_()).sorted(Comparator.comparingDouble(a -> a.m_203193_((Position)entity.m_20182_()))).toList();
        if (Thread.currentThread().isInterrupted() || entity.f_8924_.m_129918_()) {
            return;
        }
        List flattened = blocks.stream().collect(ArrayList::new, (set, blockPos) -> {
            BlockPos below = blockPos.m_7495_();
            if (!MovementUtils.canStandOn((Entity)entity, below, level.m_8055_(below))) {
                if (!blocks.contains(blockPos.m_7495_())) {
                    while (!MovementUtils.canStandOn((Entity)entity, below.m_7495_(), level.m_8055_(below.m_7495_()))) {
                        below = below.m_7495_();
                    }
                    if (!level.m_6425_(below).m_205070_(FluidTags.f_13131_) && !level.m_6425_(below).m_205070_(FluidTags.f_13132_)) {
                        set.add(below);
                        if (level.m_8055_(below).m_60795_()) {
                            Deque<BlockPos> deque = this.blocksToUpdate;
                            synchronized (deque) {
                                this.blocksToUpdate.add(below);
                            }
                        }
                    }
                }
            } else {
                set.add(blockPos);
                if (level.m_8055_(blockPos).m_60795_()) {
                    Deque<BlockPos> deque = this.blocksToUpdate;
                    synchronized (deque) {
                        this.blocksToUpdate.add((BlockPos)blockPos);
                    }
                }
            }
        }, AbstractCollection::addAll);
        List<BlockPos> unexplored = flattened.stream().filter(blockPos -> entity.getExplorationData().getCaveContaining(new MetropolizeBlockPos((BlockPos)blockPos), true) == null).toList();
        CaveSensor caveSensor = this;
        synchronized (caveSensor) {
            this.unexploredBlocks = unexplored;
        }
    }
}

