/*
 * Decompiled with CFR 0.152.
 */
package com.metropolize.mtz_companions.entity.sensors;

import com.metropolize.mtz_companions.MetropolizeMod;
import com.metropolize.mtz_companions.capabilities.IProtectedBlocksCapability;
import com.metropolize.mtz_companions.entity.ServerCompanionEntity;
import com.metropolize.mtz_companions.entity.data.memories.MemoryModuleTypes;
import com.metropolize.mtz_companions.entity.sensors.MtzSensors;
import com.metropolize.mtz_companions.utils.LootTableUtils;
import com.metropolize.mtzcharacterengine.MtzBrainOwner;
import com.metropolize.mtzcharacterengine.api.core.sensor.ExtendedSensor;
import com.metropolize.mtzcharacterengine.api.core.sensor.PredicateSensor;
import com.metropolize.mtzcharacterengine.util.BrainUtils;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.Object2ReferenceRBTreeMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.registries.RegistryObject;
import org.slf4j.Logger;

public class NearbyBlocksSensor<E extends ServerCompanionEntity>
extends PredicateSensor<BlockPos, E> {
    private static final Logger log = LogUtils.getLogger();
    private static final List<MemoryModuleType<?>> MEMORIES = ObjectArrayList.of((Object[])new MemoryModuleType[]{(MemoryModuleType)MemoryModuleTypes.ASYNC_NEAREST_WANTED_BLOCKS.get(), (MemoryModuleType)MemoryModuleTypes.ASYNC_KNOWN_CRAFTING_TABLES.get(), (MemoryModuleType)MemoryModuleTypes.ASYNC_NEAREST_CHESTS.get()});
    protected Vec3i radius = new Vec3i(16, 16, 16);
    private Future<?> blockSortingTask = null;

    public List<MemoryModuleType<?>> memoriesUsed() {
        return MEMORIES;
    }

    public SensorType<? extends ExtendedSensor<?>> type() {
        return (SensorType)MtzSensors.NEARBY_BLOCKS_SENSOR.get();
    }

    protected void doTick(ServerLevel level, E entity) {
        if (this.blockSortingTask != null && !this.blockSortingTask.isDone()) {
            return;
        }
        try {
            this.blockSortingTask = MetropolizeMod.EXECUTOR.submit(() -> this.processNearbyBlocks(level, entity));
        }
        catch (RejectedExecutionException e) {
            log.error("Executor rejected task: {}", (Object)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processNearbyBlocks(ServerLevel level, E entity) {
        Thread.currentThread().setName("MtzAsyncWorker");
        Vec3i front = entity.m_6350_().m_122436_().m_142393_(this.radius.m_123341_());
        Vec3i side = entity.m_6350_().m_122427_().m_122436_().m_142393_(this.radius.m_123343_());
        List<BlockPos> blocks = BlockPos.m_121990_((BlockPos)entity.m_20183_().m_121996_(side.m_121955_(front)).m_6625_(this.radius.m_123342_()), (BlockPos)entity.m_20183_().m_121955_(side.m_121955_(front)).m_6630_(this.radius.m_123342_())).map(BlockPos::m_7949_).filter(blockPos -> !level.m_151570_(blockPos)).toList();
        ArrayList<BlockState> states = new ArrayList<BlockState>();
        HashMap<Pair, LevelChunk> chunkMap = new HashMap<Pair, LevelChunk>();
        for (BlockPos blockPos2 : blocks) {
            Pair sectionCoords = Pair.of((Object)SectionPos.m_123171_((int)blockPos2.m_123341_()), (Object)SectionPos.m_123171_((int)blockPos2.m_123343_()));
            LevelChunk chunk = chunkMap.getOrDefault(sectionCoords, null);
            if (chunk == null) {
                chunk = level.m_6325_(((Integer)sectionCoords.left()).intValue(), ((Integer)sectionCoords.right()).intValue());
                chunkMap.put(sectionCoords, chunk);
            }
            BlockState state = chunk.m_8055_(blockPos2);
            states.add(state);
        }
        Object2ReferenceRBTreeMap wantedBlocks = new Object2ReferenceRBTreeMap(Comparator.comparingDouble(a -> a.m_203193_((Position)entity.m_20182_())));
        ArrayList<BlockPos> craftingTables = new ArrayList<BlockPos>();
        ArrayList<BlockPos> chests = new ArrayList<BlockPos>();
        ArrayList<BlockPos> furnaces = new ArrayList<BlockPos>();
        for (int i = 0; i < blocks.size(); ++i) {
            if (Thread.currentThread().isInterrupted() || ((ServerCompanionEntity)entity).f_8924_.m_129918_()) {
                return;
            }
            BlockPos blockPos3 = blocks.get(i);
            BlockState blockState = (BlockState)states.get(i);
            if (blockState.m_60795_() || !((ServerCompanionEntity)entity).hasLineOfSight(blockPos3, true)) continue;
            if (!IProtectedBlocksCapability.get((Level)level, blockPos3).isProtectedBlock(blockPos3, blockState) && LootTableUtils.blockDropsWantedItem(entity, blockPos3, blockState)) {
                wantedBlocks.put(blockPos3.m_7949_(), blockState.m_60734_());
            }
            if (blockState.m_60713_(Blocks.f_50091_)) {
                craftingTables.add(blockPos3.m_7949_());
            }
            if (blockState.m_60713_(Blocks.f_50087_) && IProtectedBlocksCapability.get((Level)level, blockPos3).isProtectedBlock(blockPos3, blockState)) {
                chests.add(blockPos3.m_7949_());
            }
            if (!(blockState.m_60734_() instanceof AbstractFurnaceBlock)) continue;
            furnaces.add(blockPos3.m_7949_());
        }
        RegistryObject<MemoryModuleType<Map<BlockPos, Block>>> registryObject = MemoryModuleTypes.ASYNC_NEAREST_WANTED_BLOCKS;
        synchronized (registryObject) {
            BrainUtils.setMemory(entity, (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.ASYNC_NEAREST_WANTED_BLOCKS.get()), (Object)wantedBlocks);
        }
        NearbyBlocksSensor.setMemorySortedByDistance(entity, MemoryModuleTypes.ASYNC_NEAREST_CHESTS, chests);
        NearbyBlocksSensor.setMemorySortedByDistance(entity, MemoryModuleTypes.ASYNC_NEAREST_FURNACES, furnaces);
        NearbyBlocksSensor.setKnownCraftingTables(entity, (Level)level, craftingTables);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setMemorySortedByDistance(ServerCompanionEntity entity, RegistryObject<MemoryModuleType<List<BlockPos>>> memoryModuleType, List<BlockPos> blocks) {
        blocks = blocks.stream().distinct().sorted(Comparator.comparingDouble(a -> a.m_203193_((Position)entity.m_20182_()))).toList();
        RegistryObject<MemoryModuleType<List<BlockPos>>> registryObject = memoryModuleType;
        synchronized (registryObject) {
            BrainUtils.setMemory((MtzBrainOwner)entity, (MemoryModuleType)((MemoryModuleType)memoryModuleType.get()), blocks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setKnownCraftingTables(ServerCompanionEntity entity, Level level, List<BlockPos> craftingTables) {
        RegistryObject<MemoryModuleType<List<BlockPos>>> registryObject = MemoryModuleTypes.ASYNC_KNOWN_CRAFTING_TABLES;
        synchronized (registryObject) {
            List previousCraftingTables = (List)BrainUtils.getMemory((MtzBrainOwner)entity, (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.ASYNC_KNOWN_CRAFTING_TABLES.get()));
            if (previousCraftingTables != null) {
                craftingTables.addAll(previousCraftingTables.stream().filter(blockPos -> level.m_8055_(blockPos).m_60713_(Blocks.f_50091_)).toList());
            }
            craftingTables = craftingTables.stream().distinct().sorted(Comparator.comparingDouble(a -> a.m_203193_((Position)entity.m_20182_()))).toList();
            BrainUtils.setMemory((MtzBrainOwner)entity, (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.ASYNC_KNOWN_CRAFTING_TABLES.get()), craftingTables);
        }
    }
}

