/*
 * Decompiled with CFR 0.152.
 */
package com.metropolize.mtz_companions.entity.sensors;

import com.google.common.collect.Lists;
import com.metropolize.mtz_companions.entity.data.memories.MemoryModuleTypes;
import com.metropolize.mtz_companions.entity.sensors.MtzSensors;
import com.metropolize.mtzcharacterengine.api.core.sensor.EntityFilteringSensor;
import com.metropolize.mtzcharacterengine.api.core.sensor.ExtendedSensor;
import java.util.List;
import java.util.function.BiPredicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.monster.Enemy;
import org.jetbrains.annotations.Nullable;

public class NearbyHostileSensor<E extends LivingEntity>
extends EntityFilteringSensor<List<LivingEntity>, E> {
    private final int HOSTILE_RANGE = 32;

    public MemoryModuleType<List<LivingEntity>> getMemory() {
        return (MemoryModuleType)MemoryModuleTypes.NEAREST_ENEMIES.get();
    }

    public SensorType<? extends ExtendedSensor<?>> type() {
        return (SensorType)MtzSensors.NEARBY_HOSTILE_SENSOR.get();
    }

    protected BiPredicate<LivingEntity, E> predicate() {
        return (target, e) -> {
            if (!(target instanceof Enemy) || target instanceof NeutralMob) {
                return false;
            }
            return !(target.m_20270_((Entity)e) > 32.0f);
        };
    }

    @Nullable
    protected List<LivingEntity> findMatches(E entity, NearestVisibleLivingEntities matcher) {
        return Lists.newArrayList((Iterable)matcher.m_186123_(target -> this.predicate().test((LivingEntity)target, entity)));
    }
}

