/*
 * Decompiled with CFR 0.152.
 */
package com.metropolize.mtz_companions.entity.sensors;

import com.metropolize.mtz_companions.entity.ServerCompanionEntity;
import com.metropolize.mtz_companions.entity.data.memories.MemoryModuleTypes;
import com.metropolize.mtz_companions.entity.sensors.MtzSensors;
import com.metropolize.mtzcharacterengine.api.core.sensor.ExtendedSensor;
import com.metropolize.mtzcharacterengine.api.core.sensor.PredicateSensor;
import com.metropolize.mtzcharacterengine.util.BrainUtils;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class NearestBedSensor<E extends ServerCompanionEntity>
extends PredicateSensor<E, E> {
    private static final List<MemoryModuleType<?>> MEMORIES = ObjectArrayList.of((Object[])new MemoryModuleType[]{MemoryModuleTypes.NEAREST_AVAILABLE_BEDS.get(), (MemoryModuleType)MemoryModuleTypes.KNOWN_BEDS.get()});
    public static final BiPredicate<ServerCompanionEntity, BlockPos> availableBedPredicate = (companion, pos) -> {
        List sleepingEntities = companion.m_9236_().m_6443_(LivingEntity.class, new AABB(pos), entity -> !(entity instanceof AbstractVillager) && entity.m_5803_());
        return sleepingEntities.isEmpty();
    };
    protected BiPredicate<E, BlockPos> isBedPredicate = (entity, pos) -> {
        Level level = entity.m_9236_();
        BlockState state = level.m_8055_(pos);
        return state.m_60734_() instanceof BedBlock;
    };
    protected int radius = 16;

    public NearestBedSensor<E> setRadius(int radius) {
        this.radius = radius;
        return this;
    }

    public List<MemoryModuleType<?>> memoriesUsed() {
        return MEMORIES;
    }

    public SensorType<? extends ExtendedSensor<?>> type() {
        return (SensorType)MtzSensors.NEAREST_BED_SENSOR.get();
    }

    protected void doTick(ServerLevel level, E entity) {
        List<BlockPos> unoccupiedBeds;
        PoiManager poiManager = level.m_8904_();
        Predicate<BlockPos> blockPosPredicate = pos -> this.isBedPredicate.test(entity, (BlockPos)pos);
        ArrayList<BlockPos> beds = new ArrayList<BlockPos>(Optional.ofNullable((List)BrainUtils.getMemory(entity, (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.KNOWN_BEDS.get()))).orElse(new ArrayList()));
        List<BlockPos> bedLocations = poiManager.m_217983_(poiType -> poiType.m_203565_(PoiTypes.f_218060_), blockPosPredicate, entity.m_20183_(), this.radius, PoiManager.Occupancy.ANY).map(Pair::getSecond).toList();
        beds.addAll(bedLocations);
        List<BlockPos> updatedBeds = beds.stream().filter(blockPosPredicate).distinct().sorted(Comparator.comparingDouble(a -> a.m_203193_((Position)entity.mtzPosition()))).toList();
        BrainUtils.setMemory(entity, (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.KNOWN_BEDS.get()), updatedBeds);
        BrainUtils.clearMemory(entity, MemoryModuleTypes.NEAREST_AVAILABLE_BEDS.get());
        if (!updatedBeds.isEmpty() && !(unoccupiedBeds = updatedBeds.stream().filter(blockPos -> availableBedPredicate.test((ServerCompanionEntity)entity, (BlockPos)blockPos)).toList()).isEmpty()) {
            BrainUtils.setMemory(entity, MemoryModuleTypes.NEAREST_AVAILABLE_BEDS.get(), unoccupiedBeds);
        }
    }
}

