/*
 * Decompiled with CFR 0.152.
 */
package com.metropolize.mtz_companions.events;

import com.metropolize.mtz_companions.capabilities.IProtectedBlocksCapability;
import com.metropolize.mtz_companions.core.MetropolizeBlockPos;
import com.metropolize.mtz_companions.entity.ServerCompanionEntity;
import com.mojang.logging.LogUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.VanillaGameEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.slf4j.Logger;

@Mod.EventBusSubscriber(modid="mtz_companions", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class BlockPlacementHandler {
    private static final Logger log = LogUtils.getLogger();

    @SubscribeEvent
    public static void onBlockPlace(BlockEvent.EntityPlaceEvent event) {
        Entity entity;
        if (!(event instanceof BlockEvent.EntityMultiPlaceEvent) && (entity = event.getEntity()) instanceof ServerPlayer) {
            IProtectedBlocksCapability protectedBlocksCapability;
            ServerPlayer player = (ServerPlayer)entity;
            if (!(event.getEntity() instanceof ServerCompanionEntity) && (protectedBlocksCapability = IProtectedBlocksCapability.get((Level)((ServerLevel)event.getLevel()), event.getPos())) != null) {
                protectedBlocksCapability.setBlockPlaced((ServerLevel)event.getLevel(), player, new MetropolizeBlockPos(event.getPos()));
            }
        }
    }

    @SubscribeEvent
    public static void onBlockMultiPlace(BlockEvent.EntityMultiPlaceEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            if (!(event.getEntity() instanceof ServerCompanionEntity)) {
                for (BlockSnapshot snapshot : event.getReplacedBlockSnapshots()) {
                    ServerLevel level = (ServerLevel)snapshot.getLevel();
                    if (level == null) continue;
                    IProtectedBlocksCapability protectedBlocksCapability = IProtectedBlocksCapability.get((Level)level, snapshot.getPos());
                    if (protectedBlocksCapability != null) {
                        protectedBlocksCapability.setBlockPlaced(level, player, new MetropolizeBlockPos(snapshot.getPos()));
                        continue;
                    }
                    log.warn("ProtectedBlocksCapability was null for BlockPos {}", (Object)snapshot.getPos());
                }
            }
        }
    }

    @SubscribeEvent
    public static void onBlockDestroyed(VanillaGameEvent event) {
        if (event.getVanillaEvent() != GameEvent.f_157794_) {
            return;
        }
        BlockPos eventPos = BlockPos.m_274446_((Position)event.getEventPosition());
        ServerLevel level = (ServerLevel)event.getLevel();
        IProtectedBlocksCapability protectedBlocksCapability = IProtectedBlocksCapability.get((Level)level, eventPos);
        if (protectedBlocksCapability != null) {
            protectedBlocksCapability.onBlockRemoved(new MetropolizeBlockPos(eventPos));
        }
    }

    @SubscribeEvent
    public static void onBlockDestroyed(ExplosionEvent.Detonate event) {
        ServerLevel level = (ServerLevel)event.getLevel();
        for (BlockPos affectedBlock : event.getAffectedBlocks()) {
            IProtectedBlocksCapability protectedBlocksCapability = IProtectedBlocksCapability.get((Level)level, affectedBlock);
            if (protectedBlocksCapability == null) continue;
            protectedBlocksCapability.onBlockRemoved(new MetropolizeBlockPos(affectedBlock));
        }
    }
}

