/*
 * Decompiled with CFR 0.152.
 */
package com.metropolize.mtz_companions.movement;

import com.metropolize.mtz_companions.core.MetropolizeBlockPos;
import com.metropolize.mtz_companions.entity.ServerCompanionEntity;
import com.metropolize.mtz_companions.utils.BlockBreakUtils;
import com.metropolize.mtz_companions.utils.LootTableUtils;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.control.Control;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeMod;
import org.joml.Vector3d;

public class BlockBreakControl<E extends ServerCompanionEntity>
implements Control {
    private final E entity;
    private boolean wasBreaking = false;
    private boolean breaking = false;
    private ServerLevel level = null;
    private MetropolizeBlockPos target = null;
    private int destroyTicks = 0;
    private ItemStack fastestTool = null;
    private float destroyProgress = 0.0f;
    private boolean equipTool = false;
    private boolean resetProgressFlag = false;

    public boolean wasBreaking() {
        return this.wasBreaking;
    }

    public void breakBlock(ServerLevel level, BlockPos blockPos, boolean equipTool) {
        this.breaking = true;
        this.wasBreaking = true;
        if (this.level != level || !blockPos.equals((Object)this.target)) {
            this.resetProgressFlag = true;
            this.resetProgress();
        }
        this.level = level;
        this.target = new MetropolizeBlockPos(blockPos);
        this.equipTool = equipTool;
        if (this.equipTool) {
            this.fastestTool = BlockBreakUtils.getFastestTool(((ServerCompanionEntity)this.entity).getInventory(), level.m_8055_(blockPos), false);
        }
        this.resetProgressFlag = false;
    }

    public void tick() {
        if (!this.breaking) {
            this.resetProgress();
            return;
        }
        BlockState blockState = this.level.m_8055_((BlockPos)this.target);
        if (blockState.m_60795_()) {
            this.resetProgress();
            return;
        }
        if (this.equipTool) {
            ((ServerCompanionEntity)this.entity).getInventory().m_36012_(this.fastestTool);
            if (!ItemStack.m_150942_((ItemStack)this.entity.m_21205_(), (ItemStack)this.fastestTool)) {
                this.resetProgress();
                return;
            }
        }
        this.entity.m_6674_(InteractionHand.MAIN_HAND);
        boolean didBreak = this.addBlockBreakProgress(blockState);
        if (didBreak) {
            this.entity.m_36399_(0.005f);
            this.entity.m_21205_().m_41686_((Level)this.level, blockState, (BlockPos)this.target, this.entity);
        }
        this.breaking = false;
    }

    private boolean addBlockBreakProgress(BlockState blockState) {
        BlockHitResult result = (BlockHitResult)this.entity.m_19907_(this.entity.m_21133_((Attribute)ForgeMod.BLOCK_REACH.get()), 1.0f, false);
        Vector3d particlePos = this.getParticleLocation(this.target, blockState, result.m_82434_());
        if (particlePos != null) {
            this.level.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockState), particlePos.x, particlePos.y, particlePos.z, 1, 0.0, 0.0, 0.0, 0.15);
        }
        if (this.destroyTicks % 4 == 0) {
            SoundType blockSoundType = blockState.m_60827_();
            this.level.m_5594_(this.entity, (BlockPos)this.target, blockSoundType.m_56778_(), SoundSource.BLOCKS, (blockSoundType.f_56731_ + 1.0f) / 8.0f, blockSoundType.f_56732_ * 0.5f);
        }
        ++this.destroyTicks;
        this.destroyProgress += BlockBreakUtils.getDestroyProgressPerTick(this.entity, this.entity.m_21205_(), blockState);
        int destroyStage = this.destroyProgress > 0.0f ? (int)(this.destroyProgress * 10.0f) : -1;
        this.level.m_6801_(this.entity.m_19879_(), (BlockPos)this.target, destroyStage);
        if (this.destroyProgress >= 1.0f) {
            this.level.m_46796_(2001, (BlockPos)this.target, Block.m_49956_((BlockState)blockState));
            if (LootTableUtils.isCorrectToolForDrops(blockState, this.entity.m_21205_())) {
                Block.dropResources((BlockState)blockState, (Level)this.level, (BlockPos)this.target, (BlockEntity)this.level.m_7702_((BlockPos)this.target), this.entity, (ItemStack)this.entity.m_21205_(), (boolean)true);
            }
            this.level.m_7471_((BlockPos)this.target, false);
            return true;
        }
        return false;
    }

    private void resetProgress() {
        if (!this.resetProgressFlag) {
            this.resetProgressFlag = true;
            return;
        }
        if (this.level != null) {
            this.level.m_6801_(this.entity.m_19879_(), (BlockPos)this.target, -1);
        }
        this.destroyProgress = 0.0f;
        this.destroyTicks = 0;
        this.wasBreaking = false;
    }

    @Nullable
    private Vector3d getParticleLocation(BlockPos blockPos, BlockState blockState, Direction direction) {
        VoxelShape shape = blockState.m_60808_((BlockGetter)this.level, blockPos);
        if (shape.m_83281_()) {
            return null;
        }
        AABB aabb = shape.m_83215_();
        double d0 = (double)blockPos.m_123341_() + this.level.f_46441_.m_188500_() * (aabb.f_82291_ - aabb.f_82288_ - (double)0.2f) + (double)0.1f + aabb.f_82288_;
        double d1 = (double)blockPos.m_123342_() + this.level.f_46441_.m_188500_() * (aabb.f_82292_ - aabb.f_82289_ - (double)0.2f) + (double)0.1f + aabb.f_82289_;
        double d2 = (double)blockPos.m_123343_() + this.level.f_46441_.m_188500_() * (aabb.f_82293_ - aabb.f_82290_ - (double)0.2f) + (double)0.1f + aabb.f_82290_;
        switch (direction) {
            case DOWN: {
                d1 = (double)blockPos.m_123342_() + aabb.f_82289_ - (double)0.1f;
                break;
            }
            case UP: {
                d1 = (double)blockPos.m_123342_() + aabb.f_82292_ + (double)0.1f;
                break;
            }
            case NORTH: {
                d2 = (double)blockPos.m_123343_() + aabb.f_82290_ - (double)0.1f;
                break;
            }
            case SOUTH: {
                d2 = (double)blockPos.m_123343_() + aabb.f_82293_ + (double)0.1f;
                break;
            }
            case WEST: {
                d0 = (double)blockPos.m_123341_() + aabb.f_82288_ - (double)0.1f;
                break;
            }
            case EAST: {
                d0 = (double)blockPos.m_123341_() + aabb.f_82291_ + (double)0.1f;
            }
        }
        return new Vector3d(d0, d1, d2);
    }

    public BlockBreakControl(E entity) {
        this.entity = entity;
    }

    public MetropolizeBlockPos getTarget() {
        return this.target;
    }
}

