/*
 * Decompiled with CFR 0.152.
 */
package com.metropolize.mtz_companions.movement;

import com.metropolize.mtz_companions.core.MetropolizeBlockPos;
import com.metropolize.mtz_companions.entity.CompanionContainer;
import com.metropolize.mtz_companions.entity.ServerCompanionEntity;
import com.metropolize.mtz_companions.entity.metropolize.MtzItemConstants;
import com.metropolize.mtz_companions.utils.BlockPlacementUtils;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.NonNull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.control.Control;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.slf4j.Logger;

@ParametersAreNonnullByDefault
public class BlockPlaceControl<E extends ServerCompanionEntity>
implements Control {
    private static final Logger log = LogUtils.getLogger();
    @NonNull
    protected final E companion;
    protected BlockPos placementTarget = null;
    protected boolean trackPlaced = false;
    protected final List<BlockPos> placedBlocks = new ArrayList<BlockPos>();

    public boolean hasPlacementTarget() {
        return this.placementTarget != null;
    }

    private void setMainHandItem() {
        if (!((ServerCompanionEntity)this.companion).hasSpareBlocks()) {
            return;
        }
        CompanionContainer inventory = ((ServerCompanionEntity)this.companion).getInventory();
        ItemStack spareBlock = inventory.findFirstItemSlot(itemStack -> MtzItemConstants.PATHFINDING_BLOCKS.contains(itemStack.m_41720_()));
        ((ServerCompanionEntity)this.companion).m_8061_(EquipmentSlot.MAINHAND, spareBlock);
    }

    public void tick() {
        BlockPos target = this.placementTarget;
        this.placementTarget = null;
        if (target == null || !((ServerCompanionEntity)this.companion).isBlockInRange(target) || !((ServerCompanionEntity)this.companion).hasLineOfSight(target, false)) {
            return;
        }
        this.setMainHandItem();
        Pair<BlockPos, Direction> adjacentBlock = this.getAdjacentBlock(target);
        if (adjacentBlock == null) {
            return;
        }
        ServerLevel level = (ServerLevel)this.companion.m_9236_();
        ItemStack mainHandItem = this.companion.m_21205_();
        BlockPlaceContext context = new BlockPlaceContext(this.companion, InteractionHand.MAIN_HAND, mainHandItem, new BlockHitResult(((BlockPos)adjacentBlock.getFirst()).m_252807_(), (Direction)adjacentBlock.getSecond(), (BlockPos)adjacentBlock.getFirst(), false));
        BlockState placementBlockState = ((BlockItem)mainHandItem.m_41720_()).m_40614_().m_5573_(context);
        if (placementBlockState == null) {
            log.warn("BlockState for placement is null");
            return;
        }
        if (!context.m_7059_() || this.companion.m_20186_() <= target.m_252807_().m_7098_()) {
            return;
        }
        BlockPlacementUtils.placeBlock(this.companion, level, mainHandItem, placementBlockState, target, (Direction)adjacentBlock.getSecond(), true);
        if (this.trackPlaced) {
            this.placedBlocks.add(target);
        }
    }

    @Nullable
    protected Pair<BlockPos, Direction> getAdjacentBlock(BlockPos blockPos) {
        ServerLevel level = (ServerLevel)this.companion.m_9236_();
        Item mainHandItem = this.companion.m_21205_().m_41720_();
        if (!(mainHandItem instanceof BlockItem)) {
            return null;
        }
        if (!BlockPlacementUtils.canPlace(this.companion, (BlockItem)mainHandItem, blockPos)) {
            return null;
        }
        Direction direction = BlockPlacementUtils.getSupportingDirection(this.companion, (Level)level, new MetropolizeBlockPos(blockPos));
        if (direction == null) {
            return null;
        }
        return Pair.of((Object)blockPos.m_121945_(direction), (Object)direction.m_122424_());
    }

    public void startTrackingPlaced() {
        this.trackPlaced = true;
        this.placedBlocks.clear();
    }

    public void stopTrackingPlaced() {
        this.trackPlaced = false;
        this.placedBlocks.clear();
    }

    public BlockPlaceControl(@NonNull E companion) {
        if (companion == null) {
            throw new NullPointerException("companion is marked non-null but is null");
        }
        this.companion = companion;
    }

    public void setPlacementTarget(BlockPos placementTarget) {
        this.placementTarget = placementTarget;
    }

    public List<BlockPos> getPlacedBlocks() {
        return this.placedBlocks;
    }
}

