/*
 * Decompiled with CFR 0.152.
 */
package com.metropolize.mtz_companions.movement;

import com.metropolize.mtz_companions.entity.ServerCompanionEntity;
import java.util.Optional;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.control.Control;
import net.minecraft.world.phys.Vec3;

public class LookControl
implements Control {
    protected final ServerCompanionEntity entity;
    protected float yMaxRotSpeed;
    protected float xMaxRotAngle;
    protected int lookAtCooldown;
    protected double wantedX;
    protected double wantedY;
    protected double wantedZ;

    public LookControl(ServerCompanionEntity entity) {
        this.entity = entity;
    }

    public void setLookAt(Vec3 p_24965_) {
        this.setLookAt(p_24965_.f_82479_, p_24965_.f_82480_, p_24965_.f_82481_);
    }

    public void setLookAt(Entity p_148052_) {
        this.setLookAt(p_148052_.m_20185_(), LookControl.getWantedY(p_148052_), p_148052_.m_20189_());
    }

    public void setLookAt(Entity p_24961_, float p_24962_, float p_24963_) {
        this.setLookAt(p_24961_.m_20185_(), LookControl.getWantedY(p_24961_), p_24961_.m_20189_(), p_24962_, p_24963_);
    }

    public void setLookAt(double p_24947_, double p_24948_, double p_24949_) {
        this.setLookAt(p_24947_, p_24948_, p_24949_, this.entity.getHeadRotSpeed(), this.entity.getMaxHeadXRot());
    }

    public void setLookAt(double p_24951_, double p_24952_, double p_24953_, float p_24954_, float p_24955_) {
        this.wantedX = p_24951_;
        this.wantedY = p_24952_;
        this.wantedZ = p_24953_;
        this.yMaxRotSpeed = p_24954_;
        this.xMaxRotAngle = p_24955_;
        this.lookAtCooldown = 2;
    }

    public void tick() {
        if (this.resetXRotOnTick()) {
            this.entity.m_146926_(0.0f);
        }
        if (this.lookAtCooldown > 0) {
            --this.lookAtCooldown;
            this.getYRotD().ifPresent(p_287447_ -> {
                this.entity.f_20885_ = this.rotateTowards(this.entity.f_20885_, p_287447_.floatValue(), this.yMaxRotSpeed);
            });
            this.getXRotD().ifPresent(p_289400_ -> this.entity.m_146926_(this.rotateTowards(this.entity.m_146909_(), p_289400_.floatValue(), this.xMaxRotAngle)));
        } else {
            this.entity.f_20885_ = this.rotateTowards(this.entity.f_20885_, this.entity.f_20883_, 10.0f);
        }
        this.clampHeadRotationToBody();
    }

    protected void clampHeadRotationToBody() {
        this.entity.f_20885_ = Mth.m_14094_((float)this.entity.f_20885_, (float)this.entity.f_20883_, (float)this.entity.getMaxHeadYRot());
    }

    protected boolean resetXRotOnTick() {
        return true;
    }

    public boolean isLookingAtTarget() {
        return this.lookAtCooldown > 0;
    }

    protected Optional<Float> getXRotD() {
        double d0 = this.wantedX - this.entity.m_20185_();
        double d1 = this.wantedY - this.entity.m_20188_();
        double d2 = this.wantedZ - this.entity.m_20189_();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        return !(Math.abs(d1) > (double)1.0E-5f) && !(Math.abs(d3) > (double)1.0E-5f) ? Optional.empty() : Optional.of(Float.valueOf((float)(-(Mth.m_14136_((double)d1, (double)d3) * 57.2957763671875))));
    }

    protected Optional<Float> getYRotD() {
        double d0 = this.wantedX - this.entity.m_20185_();
        double d1 = this.wantedZ - this.entity.m_20189_();
        return !(Math.abs(d1) > (double)1.0E-5f) && !(Math.abs(d0) > (double)1.0E-5f) ? Optional.empty() : Optional.of(Float.valueOf((float)(Mth.m_14136_((double)d1, (double)d0) * 57.2957763671875) - 90.0f));
    }

    protected float rotateTowards(float p_24957_, float p_24958_, float p_24959_) {
        float f = Mth.m_14118_((float)p_24957_, (float)p_24958_);
        float f1 = Mth.m_14036_((float)f, (float)(-p_24959_), (float)p_24959_);
        return p_24957_ + f1;
    }

    private static double getWantedY(Entity p_24967_) {
        return p_24967_ instanceof LivingEntity ? p_24967_.m_20188_() : (p_24967_.m_20191_().f_82289_ + p_24967_.m_20191_().f_82292_) / 2.0;
    }

    public double getWantedX() {
        return this.wantedX;
    }

    public double getWantedZ() {
        return this.wantedZ;
    }
}

