/*
 * Decompiled with CFR 0.152.
 */
package com.metropolize.mtz_companions.navigation;

import com.metropolize.mtz_companions.MetropolizeMod;
import com.metropolize.mtz_companions.core.MetropolizeBlockPos;
import com.metropolize.mtz_companions.entity.ServerCompanionEntity;
import com.metropolize.mtz_companions.navigation.MtzWalkTarget;
import com.metropolize.mtz_companions.navigation.move.Move;
import com.metropolize.mtz_companions.navigation.move.Moves;
import com.metropolize.mtz_companions.navigation.path.Path;
import com.metropolize.mtz_companions.navigation.path.PathNode;
import com.metropolize.mtz_companions.navigation.path.PathNodeContext;
import com.metropolize.mtz_companions.navigation.utils.PathNodeBinaryHeap;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;

@ParametersAreNonnullByDefault
public class CompanionPathfinder {
    private static final Logger log = LogUtils.getLogger();
    private static final int RECOMPUTE_DELAY = 10;
    private static final int INDEX_PENALTY_FACTOR = 10;
    protected final int failureTimeout;
    protected final ServerCompanionEntity entity;
    protected MetropolizeBlockPos startPosition;
    protected List<MtzWalkTarget> targets;
    protected volatile Path path = null;
    protected volatile MtzWalkTarget reachedTarget;
    private volatile MetropolizeBlockPos reachedBlockPos;
    protected Object2ObjectOpenHashMap<Vec3, PathNode> nodeMap;
    private Future<?> pathfindingTask = null;
    private int ticksSinceRecompute = 10;

    public CompanionPathfinder(ServerCompanionEntity entity) {
        this.entity = entity;
        this.failureTimeout = 500;
    }

    public boolean setGoal(MetropolizeBlockPos startPosition, List<MtzWalkTarget> targets) {
        if (targets.isEmpty() || this.isCurrentGoal(startPosition, targets)) {
            return false;
        }
        this.clear();
        this.startPosition = startPosition;
        this.targets = targets;
        return true;
    }

    public void tick() {
        ++this.ticksSinceRecompute;
        if (this.startPosition == null || this.targets == null) {
            return;
        }
        if (this.isRunning()) {
            return;
        }
        if (this.reachedTarget != null) {
            if (!this.reachedTarget.isReached(this.entity, this.reachedBlockPos)) {
                this.reachedTarget = null;
                this.reachedBlockPos = null;
            } else {
                return;
            }
        }
        if (this.ticksSinceRecompute > 10) {
            this.ticksSinceRecompute = 0;
            try {
                this.pathfindingTask = MetropolizeMod.EXECUTOR.submit(this::findPath);
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }
    }

    public void setPath(MtzWalkTarget target, MetropolizeBlockPos reachedPos, Path path) {
        this.clear();
        this.path = path;
        this.reachedTarget = target;
        this.reachedBlockPos = reachedPos;
        if (this.path != null && this.path.length() > 0) {
            this.startPosition = path.getNode((int)0).blockPos;
        }
    }

    public void clear() {
        if (this.pathfindingTask != null) {
            this.pathfindingTask.cancel(true);
        }
        this.ticksSinceRecompute = 10;
        this.path = null;
        this.startPosition = null;
        this.targets = null;
        this.reachedTarget = null;
        this.reachedBlockPos = null;
    }

    public boolean hasGoal() {
        return this.targets != null;
    }

    public boolean isRunning() {
        return this.pathfindingTask != null && !this.pathfindingTask.isDone();
    }

    public boolean didSucceed() {
        return this.reachedTarget != null;
    }

    protected boolean isCurrentGoal(MetropolizeBlockPos startPosition, List<MtzWalkTarget> targets) {
        if (this.targets == null || this.startPosition == null) {
            return false;
        }
        boolean sameTargets = this.targets.stream().map(MtzWalkTarget::getTargetBlockPos).allMatch(tbp -> targets.stream().map(MtzWalkTarget::getTargetBlockPos).collect(Collectors.toSet()).contains(tbp));
        if (this.isRunning()) {
            if (this.path != null) {
                return sameTargets && this.path.nodes().stream().anyMatch(node -> node.blockPos.equals((Object)startPosition));
            }
            return sameTargets && startPosition.equals((Object)this.startPosition);
        }
        if (this.path == null) {
            return false;
        }
        if (!this.didSucceed()) {
            return sameTargets && this.path.nodes().stream().anyMatch(node -> node.blockPos.equals((Object)startPosition));
        }
        boolean nodesMatch = this.path.nodes().stream().anyMatch(node -> PathNode.isAlongNode(startPosition, node));
        return nodesMatch && targets.stream().anyMatch(t -> t.isReached(this.entity, this.reachedBlockPos));
    }

    protected synchronized void findPath() {
        Thread.currentThread().setName("MtzAsyncWorker");
        this.nodeMap = new Object2ObjectOpenHashMap();
        long startTime = System.currentTimeMillis();
        PathNode startNode = this.getPathNode(this.startPosition.m_252807_().m_82492_(0.0, 0.5, 0.0));
        startNode.setCost(0.0);
        startNode.pathNodeContext = new PathNodeContext(this.entity.m_9236_());
        PathNodeBinaryHeap openSet = new PathNodeBinaryHeap();
        openSet.insert(startNode);
        PathNode bestSoFar = startNode;
        while (!openSet.isEmpty()) {
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            if (System.currentTimeMillis() - startTime > (long)this.failureTimeout) {
                log.debug("Navigation timed out for target(s) {}", (Object)this.targets.toString());
                break;
            }
            PathNode currentNode = openSet.pop();
            PathNodeContext ctx = currentNode.pathNodeContext;
            Optional<MtzWalkTarget> reachedTarget = this.targets.stream().filter(t -> currentNode.getTotalCost() < t.getMaxCost() && t.isReached(this.entity, currentNode.blockPos)).findFirst();
            if (reachedTarget.isPresent()) {
                EntityTracker entityTracker;
                this.reachedTarget = reachedTarget.get();
                this.reachedBlockPos = currentNode.blockPos;
                Path path = new Path(this.entity.m_9236_(), startNode, currentNode);
                PositionTracker positionTracker = this.reachedTarget.m_26420_();
                if (positionTracker instanceof EntityTracker && (entityTracker = (EntityTracker)positionTracker).m_147481_() instanceof ItemEntity) {
                    PathNode lastNode = path.getLastNode();
                    BlockPos delta = this.reachedTarget.getTargetBlockPos().m_121996_((Vec3i)this.reachedBlockPos);
                    lastNode.pos.m_82549_(new Vec3(Mth.m_14008_((double)delta.m_123341_(), (double)-0.5, (double)0.5), Mth.m_14008_((double)delta.m_123342_(), (double)-0.5, (double)0.5), Mth.m_14008_((double)delta.m_123343_(), (double)-0.5, (double)0.5)));
                }
                this.path = path;
                return;
            }
            for (Move move : Moves.values()) {
                Move.Result moveResult = move.from(this.entity, currentNode);
                assert (moveResult.cost > 0.0);
                if (moveResult.cost == Double.POSITIVE_INFINITY || moveResult.pos.f_82480_ < (double)ctx.minHeight || moveResult.pos.f_82480_ > (double)ctx.maxHeight) continue;
                PathNode neighbor = this.getPathNode(moveResult.pos);
                double cost = currentNode.getCost() + moveResult.cost;
                if (!(cost < neighbor.getCost())) continue;
                neighbor.setCost(cost);
                neighbor.previous = currentNode;
                neighbor.pathNodeContext = moveResult.context;
                neighbor.setMove(move);
                if (neighbor.openSetPosition == -1) {
                    openSet.insert(neighbor);
                } else {
                    openSet.upHeap(neighbor);
                }
                if (!(bestSoFar.costToTarget > neighbor.costToTarget)) continue;
                bestSoFar = neighbor;
            }
        }
        this.path = !bestSoFar.blockPos.equals((Object)startNode.blockPos) ? new Path(this.entity.m_9236_(), startNode, bestSoFar) : null;
    }

    protected PathNode createPathNode(Vec3 position) {
        double minCost = IntStream.range(0, this.targets.size()).mapToDouble(index -> position.m_82554_(this.targets.get(index).m_26420_().m_6675_().m_252807_()) + (double)(index * 10)).min().orElseThrow();
        return new PathNode(this.entity.m_9236_(), position, minCost);
    }

    protected PathNode getPathNode(Vec3 pos) {
        PathNode node = (PathNode)this.nodeMap.get((Object)pos);
        if (node == null) {
            node = this.createPathNode(pos);
            this.nodeMap.put((Object)pos, (Object)node);
        }
        return node;
    }

    public Path getPath() {
        return this.path;
    }

    public MtzWalkTarget getReachedTarget() {
        return this.reachedTarget;
    }

    public MetropolizeBlockPos getReachedBlockPos() {
        return this.reachedBlockPos;
    }
}

